<?php

// Prevent the server from timing out
set_time_limit(0);

// Include the web sockets server script
require_once ('vendor/autoload.php');
require 'sockets/class.PHPWebSocket.php';

/*
 * Classes for setting operations that have to communicate with socket server
 * */
require_once ('operations/ExamplesOperations.php');
require_once ('operations/ImportOperations.php');
require_once ('operations/OmekaInfoOperations.php');
require_once ('operations/ScanAppOperations.php');

date_default_timezone_set("UTC");

// Options declared with '-'
$shortOptions = "";
// Options declared with '--'
$longOptions = array(
    'import:',
    'dryMode:',
    'createOriNameFromID:',
    'itemTitleField:',
    'forceProcedure:',
    'importFilze:',
    'getAddedItems:',
    'getModifiedItems:',
    'getLastDaysAddedItems:',
    'getLastDaysModifiedItems:',
    'download:',
    'getAddedCollections:',
    'getModifiedCollections:',
    'syncOmeka:',
    'createPublicItemsAndCollections:',
    'analyzeErrors:',
    'analyzeFolderForImport:',
    'ciniArchivesNormalization:',
    'onlyCheckNormalization:',
    'deleteCollectionsFromFolder:',
    'deleteRelatedItems:',
    'webSocket:',
    'port:',
    'h',
    'help'
);

// Parsing options passed to the script
$options = getopt($shortOptions, $longOptions);

if (count($options) > 0) {

    /**
     * @example php TMBDashboardServer.php --import data/example Launch TMBDashboardServer.php from php command line for processing "data/example" folder, convert images
     * @example php TMBDashboardServer.php --import data/example --syncOmeka 1 Launch TMBDashboardServer.php from php command line for processing "data/example" folder, convert images and create omeka data
     * @example php TMBDashboardServer.php --getAddedItems 2012-01-18T05:45:00-05:00 Get items added from 2012-01-18
     * @example php TMBDashboardServer.php --getModifiedItems 2012-01-18T05:45:00-05:00 Get items modified from 2012-01-18
     * @example php TMBDashboardServer.php --getLastDaysAddedItems 2 Get items added from last 2 days
     * @example php TMBDashboardServer.php --getLastDaysModifiedItems 3 Get items modified from last 3 days
     * @example php TMBDashboardServer.php --getLastDaysModifiedItems 3 --download all Get items modified from last 3 days and download related files and manifest
     * @example php TMBDashboardServer.php --getAddedCollections 2012-01-18T05:45:00-05:00 Get collections added from 2012-01-18
     * @example php TMBDashboardServer.php --getModifiedCollections 2012-01-18T05:45:00-05:00 --download manifest Get collections modified from 2012-01-18 and download manifest
     * @example php TMBDashboardServer.php --getAddedCollections 2017-09-13T05:45:00-05:00 --download all Get collections added from 2017-09-13 and download manifest collection and related manifest items with images
     * @example php TMBDashboardServer.php --getAddedCollections 2017-09-13T05:45:00-05:00 --download files Get collections added from 2017-09-13 and download manifest collection and related images

     * @example php TMBDashboardServer.php --analyzeErrors data/example Launch TMBDashboardServer.php from php command line for finding errors on already processed "data/example" folder
     * @example php TMBDashboardServer.php --analyzeFolderForImport data/example Launch TMBDashboardServer.php from php command line for finding errors on "data/example" folder that has to be processed
     * @example php TMBDashboardServer.php --webSocket localhost --port 9300 Launch TMBDashboardServer.php from php command line as webSocket on localhost on port 9300 - not yet supported!
     */

    /**
     * ==================================================
     * USER GUIDE
     * ==================================================
     *
     * Script execution from terminal
     *      php TMBDashboardServer.php --convertAndUpload INPUTFOLDERPATH
     *
     * INPUTFOLDERPATH Must contain
     *      INPUTFOLDERPATH_info.xlsx
     *      INPUTFOLDERPATH_tc.xlsx
     *
     * PAY ATTENTION! This script requires PHP >= 7
     */

    if (isset($options['h']) || isset($options['help'])) {

        echo "\n[TMBDashboardServer.php]\n";
        echo "Script for playing with your time machine box!\n";
        echo "Script developed by Mind@ware Srl.\n";
        echo "This script requires PHP >= 7.\n";
        echo "Usage: php TMBDashboardServer.php [params]\n";
        echo "Params available: \n";
        echo "--h                                                                       This help\n";
        echo "--import data                                                             Process \"data\" folder\n";
        echo "--import data --syncOmeka 1                                               Process \"data\" folder and push data to omeka\n";
        echo "--getAddedItems 2012-01-18T05:45:00-05:00                                 Get omeka items added from 2012-01-18\n";
        echo "--getModifiedItems 2012-01-18T05:45:00-05:00                              Get items modified from 2012-01-18\n";
        echo "--getLastDaysAddedItems 2                                                 Get items added from last 2 days\n";
        echo "--getLastDaysModifiedItems 3                                              Get items modified from last 3 days\n";
        echo "--getLastDaysModifiedItems 3 --download all                               Get items modified from last 3 days, download files and manifests\n";
        echo "--getAddedCollections 2012-01-18T05:45:00-05:00                           Get collections added from 2012-01-18\n";
        echo "--getModifiedCollections 2012-01-18T05:45:00-05:00 --download manifest    Get collections modified from 2012-01-18, download manifests\n";
        echo "--getAddedCollections 2017-09-13T05:45:00-05:00 --download all            Get collections added from 2017-09-13, download manifest collection and related manifest items with images\n";
        echo "--getAddedCollections 2017-09-13T05:45:00-05:00 --download files          Get collections added from 2017-09-13, download manifest collection and related images\n";
        echo "--analyzeErrors data                                                      Find errors on already processed \"data\" folder\n";
        echo "--analyzeFolderForImport data                                             Find errors on \"data\" folder that has to be processed\n";
        echo "--webSocket localhost --port 9300                                         Start webSocket server on localhost on port 9300 (Beta)\n";

        echo "\n";
        exit(EXIT_SUCCESS);

    }

    if (isset($options['getAddedItems'])) {
        $omekaInfoOp = new OmekaInfoOperations(null);
        $omekaInfoOp->isoDate = $options['getAddedItems'];
        isset($options['download']) ? $impOp->download = $options['download'] : $impOp->download = '';

        $omekaInfoOp->getAddedItems();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['getModifiedItems'])) {
        $omekaInfoOp = new OmekaInfoOperations(null);
        $omekaInfoOp->isoDate = $options['getModifiedItems'];
        isset($options['download']) ? $impOp->download = $options['download'] : $impOp->download = '';

        $omekaInfoOp->getModifiedItems();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['getLastDaysAddedItems'])) {
        $omekaInfoOp = new OmekaInfoOperations(null);
        $omekaInfoOp->isoDate = $options['getLastDaysAddedItems'];
        isset($options['download']) ? $impOp->download = $options['download'] : $impOp->download = '';

        $omekaInfoOp->getLastDaysAddedItems();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['getLastDaysModifiedItems'])) {
        $omekaInfoOp = new OmekaInfoOperations(null);
        $omekaInfoOp->isoDate = $options['getLastDaysModifiedItems'];
        isset($options['download']) ? $impOp->download = $options['download'] : $impOp->download = '';

        $omekaInfoOp->getLastDaysModifiedItems();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['getAddedCollections'])) {
        $omekaInfoOp = new OmekaInfoOperations(null);
        $omekaInfoOp->isoDate = $options['getAddedCollections'];
        isset($options['download']) ? $impOp->download = $options['download'] : $impOp->download = '';

        $omekaInfoOp->getAddedCollections();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['getModifiedCollections'])) {
        $omekaInfoOp = new OmekaInfoOperations(null);
        $omekaInfoOp->isoDate = $options['getModifiedCollections'];
        isset($options['download']) ? $impOp->download = $options['download'] : $impOp->download = '';

        $omekaInfoOp->getModifiedCollections();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['analyzeErrors'])) {
        $impOp = new ImportOperations(null);
        $impOp->inputFolderPath = $options['analyzeErrors'];

        $impOp->analyzeErrors();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['analyzeFolderForImport'])) {
        $impOp = new ImportOperations(null);
        $impOp->inputFolderPath = $options['analyzeFolderForImport'];
        isset($options['importFilze']) ? $impOp->importFilze = $options['importFilze'] : $impOp->importFilze = false;

        $impOp->analyzeFolderForImport();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['import'])) {
        $impOp = new ImportOperations(null);
        $impOp->inputFolderPath = $options['import'];
        isset($options['syncOmeka']) ? $impOp->syncOmeka = $options['syncOmeka'] : $impOp->syncOmeka = false;
        isset($options['createPublicItemsAndCollections']) ? $impOp->createPublicItemsAndCollections = $options['createPublicItemsAndCollections'] : $impOp->createPublicItemsAndCollections = false;
        isset($options['dryMode']) ? $impOp->dryMode = $options['dryMode'] : $impOp->dryMode = false;
        isset($options['createOriNameFromID']) ? $impOp->createOriNameFromID = $options['createOriNameFromID'] : $impOp->createOriNameFromID = true;
        isset($options['itemTitleField']) ? $impOp->itemTitleField = $options['itemTitleField'] : $impOp->itemTitleField = '';
        isset($options['forceProcedure']) ? $impOp->forceProcedure = $options['forceProcedure'] : $impOp->forceProcedure = false;
        isset($options['importFilze']) ? $impOp->importFilze = $options['importFilze'] : $impOp->importFilze = false;

        $impOp->import();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['ciniArchivesNormalization'])) {
        $impOp = new ImportOperations(null);
        $impOp->inputFolderPath = $options['ciniArchivesNormalization'];
        isset($options['onlyCheckNormalization']) ? $impOp->onlyCheckNormalization = $options['onlyCheckNormalization'] : $impOp->onlyCheckNormalization = false;

        $impOp->ciniArchivesNormalization();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['checkCiniArchivesNormalization'])) {
        $impOp = new ImportOperations(null);
        if (trim($options['checkCiniArchivesNormalization']) !== '') {
            $impOp->ciniArchivesNormalization(true, $options['checkCiniArchivesNormalization'], true);
        } else {
            echo "Specify an input folder path!";
        }
        exit(EXIT_SUCCESS);
    }

    if (isset($options['deleteCollectionsFromFolder'])) {
        $omekaInfoOp = new OmekaInfoOperations(null);
        $omekaInfoOp->importFolderPath = $options['deleteCollectionsFromFolder'];

        isset($options['deleteRelatedItems']) ? $omekaInfoOp->deleteRelatedItems = $options['deleteRelatedItems'] : $omekaInfoOp->deleteRelatedItems = true;
        isset($options['dryMode']) ? $omekaInfoOp->dryMode = $options['dryMode'] : $omekaInfoOp->dryMode = false;

        $omekaInfoOp->deleteCollectionsFromFolder();
        exit(EXIT_SUCCESS);
    }

    if (isset($options['webSocket'])) {

        $operationsGroup = "";
        $currentOperationsGroupInstance = null;
        $socketPort = isset($options['port']) ? $options['port'] : 9300;

        // Start the server
        echo "Starting websocket server on port " . $socketPort . "...\n";
        $Server = new PHPWebSocket();

        $Server->bind('message', 'wsOnMessage');
        $Server->bind('open', 'wsOnOpen');
        $Server->bind('close', 'wsOnClose');

        /*
         * For other computers to connect, you will probably need to change this to your LAN IP or external IP,
         * alternatively use: gethostbyaddr(gethostbyname($_SERVER['SERVER_NAME']))
         */
        echo "Websocket server started on port " . $socketPort . "\n";
        $Server->wsStartServer($options['webSocket'], $socketPort);

    }

} else {

    echo "\n[TMBDashboardServer.php]\n";
    echo "Script for playing with your time machine box!\n";
    echo "Script developed by Mind@ware Srl.\n";
    echo "This script requires PHP >= 7.\n";
    echo "Digit php TMBDashboardServer.php --h for help!\n";
    exit(EXIT_SUCCESS);

}

/**
 * ==================================================
 * wsOnMessage
 * ==================================================
 *
 * Function called when a client sends data to the server
 *
 * @param integer $clientID
 * @param string $message
 * @param integer $messageLength
 * @param integer $binary
 */
function wsOnMessage($clientID, $message, $messageLength, $binary) {

    global $Server;
    global $operationsGroup;
    global $currentOperationsGroupInstance;

	$ip = long2ip( $Server->wsClients[$clientID][6] );

    echo "** wsOnMessage **\n";
    echo "clientID: " . $clientID . "\n";
    echo "client IP: " . $ip . "\n";
    echo "message: " . $message . "\n";
    echo "messageLength: " . $messageLength . "\n";
    echo "binary: " . $binary . "\n";

	// Check if message length is 0
	if ($messageLength == 0) {
        $Server->wsClose($clientID);
		return;
	}

    if (strpos($message, 'setOperationsGroup') !== false) {
        $command = explode( ':', $message );
	    $operationsGroup = $command[1];
        $currentOperationsGroupInstance = null;
	}

	switch ($operationsGroup) {
        case 'Examples':
        case 'Examples for Mac OSX only':
            if ($currentOperationsGroupInstance === null) {
                $currentOperationsGroupInstance = new ExamplesOperations($Server);
            }
            break;
        case 'Import':
            if ($currentOperationsGroupInstance === null) {
                $currentOperationsGroupInstance = new ImportOperations($Server);
            }
            break;
        case 'TMB portal info':
            if ($currentOperationsGroupInstance === null) {
                $currentOperationsGroupInstance = new OmekaInfoOperations($Server);
            }
            break;
        case 'ScanApp':
            if ($currentOperationsGroupInstance === null) {
                $currentOperationsGroupInstance = new ScanAppOperations($Server);
            }
            break;
        default:
            $Server->wsSend(
                $clientID,
                "done:Group " . $operationsGroup  . " not managed on server. Check your configuration!"
            );
    }

    if ($currentOperationsGroupInstance !== null) {
        $currentOperationsGroupInstance->wsOnMessage($clientID, $message, $messageLength, $binary);
    }

    /*
    { // No commands, free chat :-)

	    // The speaker is the only person in the room. Don't let them feel lonely.
		if ( sizeof($operations->getServer()->wsClients) == 1 ) {
            $operations->getServer()->wsSend($clientID, "There isn't anyone else in the room, but I'll still listen to you. -- Your Trusty Server --");
		} else {
			// Send the message to everyone but the person who said it
			foreach ( $operations->getServer()->wsClients as $id => $client ) {
                if ($id != $clientID) {
                    $operations->getServer()->wsSend($id, "Visitor $clientID ($ip) said \"$message\"");
                }
            }
		}

	}*/

}

/**
 * ==================================================
 * wsOnOpen
 * ==================================================
 *
 * Function called when a client connects
 *
 * @param integer $clientID
 */
function wsOnOpen($clientID)
{

    global $Server;
	$ip = long2ip( $Server->wsClients[$clientID][6] );

	$Server->log( "$ip ($clientID) has connected." );

	// Send a join notice to everyone but the person who joined
	foreach ( $Server->wsClients as $id => $client ) {
        if ($id != $clientID) {
            $Server->wsSend($id, "Visitor $clientID ($ip) has joined the room.");
        }
    }

}

/**
 * ==================================================
 * wsOnClose
 * ==================================================
 *
 * Function called when a client closes or lost connection
 *
 * @param integer $clientID
 * @param integer $status
 */
function wsOnClose($clientID, $status) {

    global $Server;
	$ip = long2ip( $Server->wsClients[$clientID][6] );

	$Server->log( "$ip ($clientID) has disconnected." );

	//Send a user left notice to everyone in the room
	foreach ( $Server->wsClients as $id => $client ) {
        $Server->wsSend($id, "Visitor $clientID ($ip) has left the room.");
    }

}