<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 27/10/17
 * Time: 09:07
 */

class Database {

    // specify your own database credentials
    private $host = "localhost";
    private $db_name = "TMB_sync.sqlite";
    private $db_path = "/home/tmb/tmb-api/db/";
    private $username = "";
    private $password = "";
    private $connectionType = "sqlite";
    private $conn;

    // get the database connection
    public function getConnection(){

        $this->conn = new stdClass();
        $this->conn->PDO = null;
        $this->conn->status = "";

        try {

            switch ($this->connectionType) {
                case 'mysql':
                    $this->conn->PDO = new PDO("mysql:host=" . $this->host . ";dbname=" . $this->db_name, $this->username, $this->password);
                    $this->conn->PDO->exec("set names utf8");
                    $this->conn->status = "active";
                    break;
                case 'sqlite':
                    $this->conn->PDO = new PDO('sqlite:' . $this->db_path . $this->db_name);
                    $this->conn->PDO->setAttribute(
                        PDO::ATTR_ERRMODE,
                        PDO::ERRMODE_EXCEPTION
                    );
                    $this->conn->status = "active";
                    break;
            }

        } catch (PDOException $exception){

            $this->conn->status = "Connection error: " . $exception->getMessage();

        }

        return $this->conn;
    }
}