<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 27/10/17
 * Time: 11:37
 */

// Required headers for post
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// get database connection
include_once '../config/database.php';

// instantiate product object
include_once '../objects/log.php';

include_once '../objects/message.php';

$database = new Database();
$db = $database->getConnection();

if ($db->status !== 'active') {
    echo json_encode(new Message("", false, "Unable to create log: " . $db->status));
} else {
    $log = new Log($db->PDO);

    // get posted data
    $data = json_decode(file_get_contents("php://input"));;

    // Set log property values
    $log->operation_uuid = $data->operation_uuid;
    $log->operation = $data->operation;
    $log->description = $data->description;

    if ($log->create()) {
        echo json_encode(new Message("", true, "Log was created"));
    } else {
        echo json_encode(new Message("", false, "Unable to create log"));
    }
}