<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 27/10/17
 * Time: 09:22
 */

// required headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// include database and object files
include_once '../config/database.php';
include_once '../objects/log.php';

// instantiate database and product object
$database = new Database();
$db = $database->getConnection();

// initialize object
$log = new Log($db->PDO);

// query logs
$ret = $log->read();

$logs_arr=array();
$logs_arr["logs"]=array();

while($row = $ret->fetch(SQLITE3_ASSOC) ) {

    $log_item = array(
        "id" => $row['id']*1,
        "operation_uuid" => $row['operation_uuid'],
        "operation" => $row['operation'],
        "description" => html_entity_decode($row['description']),
        "timeinfo" => html_entity_decode($row['timeinfo']),
        "timestamp" => html_entity_decode($row['timestamp'])
    );

    array_push($logs_arr["logs"], $log_item);

}

echo json_encode($logs_arr);