<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 27/10/17
 * Time: 09:17
 */

date_default_timezone_set("UTC");

class Log {

    // database connection and table name
    private $conn;
    private $table_name = "logs";

    // object properties
    public $id;
    public $operation_uuid;
    public $operation;
    public $description;
    public $timestamp;

    // constructor with $db as database connection
    public function __construct($db){
        $this->conn = $db;
    }

    // create table
    function createTable(){

        $sql = "CREATE TABLE IF NOT EXISTS " . $this->table_name . " (";
        $sql .= "id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,";
        $sql .= "operation_uuid TEXT NOT NULL,";
        $sql .= "operation TEXT NOT NULL,";
        $sql .= "description TEXT NOT NULL,";
        // $sql .= "timeinfo TEXT NOT NULL,";
        $sql .= "timestamp INTEGER NOT NULL";
        $sql .= ")";

        $ret = $this->conn->query($sql);
        if (!$ret) {
            return false;
        } else {
            return "Table created successfully";
        }

    }

    // read logs
    function read(){
        // select all query
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY timestamp ASC";

        $ret = $this->conn->query($query);

        return $ret;
    }

    // create log
    function create(){

        // query to insert record
        $query = "INSERT INTO " . $this->table_name . " (operation_uuid, operation, description, timestamp) VALUES (:operation_uuid, :operation, :description, :timestamp)";

        // prepare query
        $stmt = $this->conn->prepare($query);

        // sanitize
        //$this->operation_uuid=htmlspecialchars(strip_tags($this->operation_uuid));
        $this->operation=htmlspecialchars(strip_tags($this->operation));
        $this->description=htmlspecialchars(strip_tags($this->description));

        $nowUtc = new \DateTime( 'now',  new \DateTimeZone( 'Europe/Rome' ) );

        // bind values
        $time = time();
        $stmt->bindParam(":operation_uuid", $this->operation_uuid);
        $stmt->bindParam(":operation", $this->operation);
        $stmt->bindParam(":description", $this->description);
        // $stmt->bindParam(":timeinfo", $nowUtc->format('d-m-Y h:i:s'));
        $stmt->bindParam(":timestamp", $time);

        // execute query
        if($stmt->execute()){
            return true;
        } else {
            return false;
        }
    }

}