<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 27/10/17
 * Time: 09:17
 */


class omekaConf {

    // database connection and table name
    private $conn;
    private $table_name = "omeka";

    // object properties
    public $id;
    public $name;
    public $apiBaseUrl;
    public $apiToken;
    public $debug;

    // constructor with $db as database connection
    public function __construct($db){
        $this->conn = $db;
    }

    // create table
    function createTable(){

        $sql = "CREATE TABLE IF NOT EXISTS " . $this->table_name . " (";
        $sql .= "id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,";
        $sql .= "name TEXT NOT NULL,";
        $sql .= "apiBaseUrl TEXT NOT NULL,";
        $sql .= "apiToken TEXT NOT NULL,";
        $sql .= "debug INTEGER NOT NULL";
        $sql .= ")";

        $ret = $this->conn->query($sql);
        if (!$ret) {
            return false;
        } else {
            return "Table " . $this->table_name . " created successfully";
        }

    }

    // read omeka conf
    function read(){
        // select all query
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY name ASC";

        $ret = $this->conn->query($query);

        return $ret;
    }

    // create omeka conf
    function create() {

        // query to insert record
        $query = "INSERT INTO " . $this->table_name . " (name, apiBaseUrl, apiToken, debug) VALUES (:name, :apiBaseUrl, :apiToken, :debug)";

        // prepare query
        $stmt = $this->conn->prepare($query);

        // sanitize
        $this->name=htmlspecialchars(strip_tags($this->name));
        $this->apiBaseUrl=htmlspecialchars(strip_tags($this->apiBaseUrl));
        $this->apiToken=htmlspecialchars(strip_tags($this->apiToken));

        // bind values
        $stmt->bindParam(":name", $this->name);
        $stmt->bindParam(":apiBaseUrl", $this->apiBaseUrl);
        $stmt->bindParam(":apiToken", $this->apiToken);
        $stmt->bindParam(":debug", $this->debug);

        // execute query
        if($stmt->execute()) {
            $query = "SELECT seq FROM sqlite_sequence WHERE name = '" . $this->table_name . "'";
            $stmt_last_id = $this->conn->prepare($query);
            $stmt_last_id->execute();
            $row = $stmt_last_id->fetch();

            //error_log("Seq: " . $row['seq']);
            return $row['seq'];
        } else {
            return false;
        }
    }

    // update omeka conf
    function update() {

        $query = "UPDATE " . $this->table_name . "
            SET
                name = :name,
                apiBaseUrl = :apiBaseUrl,
                apiToken = :apiToken,
                debug = :debug
            WHERE
                id = :id";

        // prepare query statement
        $stmt = $this->conn->prepare($query);

        // sanitize
        $this->name=htmlspecialchars(strip_tags($this->name));
        $this->apiBaseUrl=htmlspecialchars(strip_tags($this->apiBaseUrl));
        $this->apiToken=htmlspecialchars(strip_tags($this->apiToken));
        $this->debug=htmlspecialchars(strip_tags($this->debug));
        $this->id=htmlspecialchars(strip_tags($this->id));

        // bind new values
        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':apiBaseUrl', $this->apiBaseUrl);
        $stmt->bindParam(':apiToken', $this->apiToken);
        $stmt->bindParam(':debug', $this->debug);
        $stmt->bindParam(':id', $this->id);

        // execute the query
        if($stmt->execute()) {
            return true;
        }else {
            return false;
        }

    }

}