<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 27/10/17
 * Time: 11:37
 */

// Required headers for post
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// get database connection
include_once '../config/database.php';

// instantiate omeka conf object
include_once '../objects/omekaConf.php';

include_once '../objects/message.php';

$database = new Database();
$db = $database->getConnection();

if ($db->status !== 'active') {
    echo json_encode(new Message("", false, "Unable to create omeka conf: " . $db->status));
} else {
    $omekaConf = new omekaConf($db->PDO);

    // get posted data
    $data = json_decode(file_get_contents("php://input"));

    // Set log property values
    $omekaConf->name = isset($data->name) ? $data->name : 'Main';
    $omekaConf->apiBaseUrl = $data->apiBaseUrl;
    $omekaConf->apiToken = $data->apiToken;
    $omekaConf->debug = isset($data->debug) ? $data->debug : 0;

    $result = $omekaConf->create();
    //error_log("Result of read: " . $result);
    if ($result === false) {
        echo json_encode(new Message("", false, "Unable to create omeka configuration"));
    } else {
        echo json_encode(new Message($result, true, "Omeka configuration was created"));
    }
}