<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 27/10/17
 * Time: 09:22
 */

// required headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// include database and object files
include_once '../config/database.php';
include_once '../objects/omekaConf.php';

// instantiate database and product object
$database = new Database();
$db = $database->getConnection();

// initialize object
$omekaConf = new omekaConf($db->PDO);

if ($omekaConf->createTable() !== false) {

    $ret = $omekaConf->read();

    $conf_arr = array();
    $conf_arr["confs"] = array();

    while ($row = $ret->fetch(SQLITE3_ASSOC)) {

        $confs_item = array(
            "id" => $row['id'] * 1,
            "debug" => $row['debug'],
            "name" => html_entity_decode($row['name']),
            "apiBaseUrl" => html_entity_decode($row['apiBaseUrl']),
            "apiToken" => $row['apiToken']
        );

        array_push($conf_arr["confs"], $confs_item);

    }

    echo json_encode($conf_arr);

} else {

    $conf_arr = array();
    $conf_arr["confs"] = array();
    echo json_encode($conf_arr);

}