<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 27/10/17
 * Time: 09:22
 */

// required headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// include database and object files
include_once '../config/database.php';
include_once '../objects/omekaConf.php';
include_once '../objects/message.php';

// instantiate database and product object
$database = new Database();
$db = $database->getConnection();

if ($db->status !== 'active') {
    echo json_encode(new Message("", false, "Unable to update omeka conf: " . $db->status));
} else {
// initialize object
    $omekaConf = new omekaConf($db->PDO);

    // get posted data
    $data = json_decode(file_get_contents("php://input"));

    // set ID property of product to be edited
    $omekaConf->id = $data->id;

    // set omeka conf property values
    $omekaConf->name = $data->name;
    $omekaConf->debug = $data->debug;
    $omekaConf->apiBaseUrl = $data->apiBaseUrl;
    $omekaConf->apiToken = $data->apiToken;

    if ($omekaConf->update()) {
        echo json_encode(new Message("", true, "Omeka configuration was updated"));
    } else {
        echo json_encode(new Message("", false, "Unable to update omeka configuration"));
    }
}