<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 25/07/17
 * Time: 09:34
 */

require_once ('omekaAPIWrapper.php');

class OmekaAPIUtilities
{
    function getCollections($added_since = null, $modified_since = null, $download_type = null)
    {

        $omekaAPI = new OmekaAPIWrapper();
        $omekaAPI->setVerboseMode(true);
        $collections = $omekaAPI->getCollections($added_since, $modified_since);

        if (isset($added_since) && !isset($modified_since)) {
            echo("List of added collections from " . $added_since . "\n");
        } else if (!isset($added_since) && isset($modified_since)) {
            echo("List of modified collections from " . $modified_since . "\n");
        } else if (isset($added_since) && isset($modified_since)) {
            echo("List of collections added from " . $added_since . " and modified from " . $modified_since . "\n");
        } else {
            return null;
        }

        foreach ($collections as $collection) {
            echo("Collection with id: " . $collection->id . "\n");
        }

        if (isset($download_type)) {

            $now = new DateTime('NOW');
            $now = $now->format(DateTime::ATOM);
            $parentDownloadFolder = 'downloads';
            if (!file_exists($parentDownloadFolder)) {
                mkdir($parentDownloadFolder, 0777, true);
            }

            $mainDownloadFolder = $parentDownloadFolder . '/collections-download-' . $now . '/';
            if (file_exists($mainDownloadFolder)) {
                system('rm -rf ' . escapeshellarg($mainDownloadFolder));
            }
            foreach ($collections as $collection) {

                $files = $omekaAPI->collectionFilesDownload($collection->id, $download_type);
                if ($files !== null) {
                    foreach ($files as $file) {

                        $downloadFolder = $mainDownloadFolder . $collection->id . "/";

                        // Building new download Folder if not exist
                        if (!file_exists($downloadFolder)) {
                            mkdir($downloadFolder, 0777, true);
                        }

                        if ($file->type === 'manifest') {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                json_encode($file->data, JSON_UNESCAPED_SLASHES)
                            );
                        } else {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                base64_decode($file->data)
                            );
                        }

                        echo("File " . $downloadFolder . $file->filename . " created\n");

                        /*
                         * If $download_type === 'all' or 'files' then I have to parse manifest file and download item images of items belong to collection
                         * */
                        if (($download_type === 'all') || ($download_type === 'files')) {

                            echo "Parsing collection manifest file...\n";
                            //echo "File data: " . print_r($file->data, true);
                            echo "Sequences number: " . count($file->data->sequences) . "\n";
                            if (count($file->data->sequences) > 0) {
                                echo "Canvases number: " . count($file->data->sequences[0]->canvases) . "\n";
                            }

                            if ((count($file->data->sequences) > 0) && count($file->data->sequences[0]->canvases) > 0) {
                                foreach ($file->data->sequences[0]->canvases as $canvas) {
                                    $canvas_id_array = explode("/", $canvas->{'@id'});
                                    $element_id = $canvas_id_array[count($canvas_id_array) - 2];
                                    // echo "Element to retrieve: " . $element_id . "\n";
                                    $item_files = $omekaAPI->itemFilesDownload($element_id, $download_type);
                                    if ($item_files !== null) {
                                        foreach ($item_files as $item_file) {


                                            if ($item_file->type === 'manifest') {
                                                file_put_contents(
                                                    $downloadFolder . $item_file->filename,
                                                    json_encode($item_file->data, JSON_UNESCAPED_SLASHES)
                                                );
                                            } else {
                                                file_put_contents(
                                                    $downloadFolder . $item_file->filename,
                                                    base64_decode($item_file->data)
                                                );
                                            }

                                            echo("File " . $downloadFolder . $item_file->filename . " created\n");
                                        }
                                    }
                                }
                            }

                        }

                    }
                }

            }
        }

    }

    function getItems($added_since = null, $modified_since = null, $download_type = null)
    {

            $omekaAPI = new OmekaAPIWrapper();
            $omekaAPI->setVerboseMode(true);
            $items = $omekaAPI->getItems($added_since, $modified_since);

            if (isset($added_since) && !isset($modified_since)) {
                echo("List of added items from " . $added_since . "\n");
            } else if (!isset($added_since) && isset($modified_since)) {
                echo("List of modified items from " . $modified_since . "\n");
            } else if (isset($added_since) && isset($modified_since)) {
                echo("List of items added from " . $added_since . " and modified from " . $modified_since . "\n");
            } else {
                return null;
            }

            foreach ($items as $item) {
                echo("Item with id: " . $item->id . "\n");
            }

            if(isset($download_type)) {

                $now = new DateTime('NOW');
                $now = $now->format(DateTime::ATOM);
                $parentDownloadFolder = 'downloads';
                if (!file_exists($parentDownloadFolder)) {
                    mkdir($parentDownloadFolder, 0777, true);
                }

                $mainDownloadFolder = $parentDownloadFolder . '/items-download-' . $now . '/';
                if(file_exists($mainDownloadFolder)) {
                    system('rm -rf ' . escapeshellarg($mainDownloadFolder));
                }
                foreach ($items as $item) {
                    $files = $omekaAPI->itemFilesDownload($item->id, $download_type);
                    if ($files !== null) {
                        foreach ($files as $file) {
                            $downloadFolder = $mainDownloadFolder . $item->id . "/";

                            // Building new download Folder if not exist
                            if(!file_exists($downloadFolder)) {
                                mkdir($downloadFolder, 0777, true);
                            }

                            if ($file->type === 'manifest') {
                                file_put_contents(
                                    $downloadFolder . $file->filename,
                                    json_encode($file->data, JSON_UNESCAPED_SLASHES)
                                );
                            } else {
                                file_put_contents(
                                    $downloadFolder . $file->filename,
                                    base64_decode($file->data)
                                );
                            }

                            echo("File " . $mainDownloadFolder . $file->filename . " created\n");
                        }
                    }
                }
            }

    }

}