<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 24/07/17
 * Time: 15:22
 */

require_once ('./omekaApi.php');
require_once ('./utils.php');
$configs = include('config.php');

if ((!isset($_GET['elementSetName'])) || ($_GET['elementSetName'] === '')) {
    echo "Set a omeka valid elementSetName query param in the url (For example: timeMachineBoxAPI.php?elementSetName=Dublin%20Core)";
    exit(0);
}
// Example:
// http://localhost:8888/omeka-uploader/_tmb_test_insert_collection.php?elementSetName=TMB%20Collection

/*
 * Instantiate the client and set the authentication key.
 * setDebug to true for logging to php error log
 */
$omeka = new Omeka($configs['apiBaseUrl']);
$omeka->setKey($configs['apiToken']);
$omeka->setDebug($configs['debug']);

/* Get id from elementSetName */
$parameters = [];
$parameters['name'] = urldecode($_GET['elementSetName']);
$response = $omeka->element_sets->get($parameters);
$el_set_info = Zend\Json\Json::decode($response->getBody());
if ($omeka->getDebug()) {
    debug_to_console($el_set_info[0]->name . " have id: " . $el_set_info[0]->id);
}
/* Get elementSetName elements
 * Check in API configuration
 * Maximum number of API results displayed per page
 * (default 50) and adjust for returning all results!!
*/
$parameters = [];
$parameters['element_set'] = $el_set_info[0]->id;
$response = $omeka->elements->get($parameters);
$elements = Zend\Json\Json::decode($response->getBody());
if ($omeka->getDebug()) {
    debug_to_console($elements);
}
