<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 11/07/17
 * Time: 11:35
 */

require_once ('./omekaApi.php');
require_once ('./utils.php');
$configs = include('config.php');

if ((!isset($_GET['id'])) || ($_GET['id'] <= 0)) {
    echo "Set a omeka valid id query param in the url (For example: timeMachineBoxAPI.php?id=1)";
    exit(0);
}

/*
 * Instantiate the client and set the authentication key.
 * setDebug to true for logging to php error log
 */
$omeka = new Omeka($configs['apiBaseUrl']);
$omeka->setKey($configs['apiToken']);
$omeka->setDebug($configs['debug']);

/*
 * API Examples
 *
 */

/*
 * Tramite oa API in get permettiamo di passare una oggetto come parametro
 * che contiene alcune informazioni per poter scaricare i file associati ad un item di omeka.
 * E' possibile scaricare solo i file associati, i manifest in standard IIIF o entrambi.
 * Il primo parametro della funzione è l'id dell'item mentre il secondo parametro è un array di oggetti
 * (attualmente viene gestito solo il primo oggetto).
 *
 * */

/*
 * function method can have these values:
 * - download-related-files
 * - download-related-manifest
 * - download-all
 * */

/*
 * Example: download files related to $_GET['id'] item
 * */
$parameters = [];
$param = new stdClass();
$param->function = 'download-related-files';
$param->debug = true;
$parameters [] = $param;
$response = $omeka->oa->get($_GET['id'], $parameters);

$response = Zend\Json\Json::decode($response->getBody());

if (is_array($response)) {
    if ($omeka->getDebug()) {
        debug_to_console("Response returned is an array");
    }
    foreach ($response as $file) {
        file_put_contents(
            './download/' . $file->filename,
            base64_decode($file->data)
        );
        if ($omeka->getDebug()) {
            debug_to_console("File " . $file->filename . " created", "color: green; font-style: bold; font-size: 16px");
        }
    }
} else {
    file_put_contents(
        './download/' . $response->filename,
        base64_decode($response->data)
    );
    if ($omeka->getDebug()) {
        debug_to_console("File " . $response->filename . " created", "color: green; font-style: bold; font-size: 16px");
    }
}

/*
 * Example: download manifest related to $_GET['id'] item
 * */

$parameters = [];
$param = new stdClass();
$param->function = 'download-related-manifest';
$param->debug = true;
$param->type = 'Item';
$parameters [] = $param;
$response = $omeka->oa->get($_GET['id'], $parameters);

$response = Zend\Json\Json::decode($response->getBody());

if (is_array($response)) {
    if ($omeka->getDebug()) {
        debug_to_console("Response returned is an array");
    }
    foreach ($response as $file) {
        file_put_contents(
            './download/' . $file->filename,
            json_encode($file->data, JSON_UNESCAPED_SLASHES)
        );
        if ($omeka->getDebug()) {
            debug_to_console("File " . $file->filename . " created", "color: green; font-style: bold; font-size: 16px");
        }
    }
} else {
    file_put_contents(
        './download/' . $response->filename,
        json_encode($response->data, JSON_UNESCAPED_SLASHES)
    );
    if ($omeka->getDebug()) {
        debug_to_console("File " . $response->filename . " created", "color: green; font-style: bold; font-size: 16px");
    }
}

/*
 * Example: download files and related manifest related to $_GET['id'] item
 * */
$parameters = [];
$param = new stdClass();
$param->function = 'download-related-all';
$param->debug = true;
$parameters [] = $param;
$response = $omeka->oa->get($_GET['id'], $parameters);

$response = Zend\Json\Json::decode($response->getBody());

if (is_array($response)) {
    foreach ($response as $file) {
        if ($file->type === 'manifest') {
            file_put_contents(
                './download/' . $file->filename,
                json_encode($file->data, JSON_UNESCAPED_SLASHES)
            );
        } else {
            file_put_contents(
                './download/' . $file->filename,
                base64_decode($file->data)
            );
        }
        if ($omeka->getDebug()) {
            debug_to_console("File " . $file->filename . " created", "color: green; font-style: bold; font-size: 16px");
        }
    }
} else {
    if ($response->type === 'manifest') {
        file_put_contents(
            './download/' . $response->filename,
            json_encode($response->data, JSON_UNESCAPED_SLASHES)
        );
    } else {
        file_put_contents(
            './download/' . $response->filename,
            base64_decode($response->data)
        );
    }
    if ($omeka->getDebug()) {
        debug_to_console("File " . $response->filename . " created", "color: green; font-style: bold; font-size: 16px");
    }
}

/*
 * Request all public collections
 * */
/*
$omeka = new Omeka($configs['apiBaseUrl']);
$omeka->setKey($configs['apiToken']);
$omeka->setDebug($configs['debug']);

$parameters = [];
$parameters['public'] = true;

$response = $omeka->collections->get($parameters);
echo $response->getBody();
*/

/*
 * Crea una nuova collezione
 * */
$omeka = new Omeka($configs['apiBaseUrl']);
$omeka->setKey($configs['apiToken']);
$omeka->setDebug($configs['debug']);

/* Prelevo i valori del Dublin Core*/
$parameters = [];
$parameters['name'] = "Dublin Core";
$response = $omeka->element_sets->get($parameters);
$el_set_info = Zend\Json\Json::decode($response->getBody());
if ($omeka->getDebug()) {
    debug_to_console($el_set_info[0]->name . " have id: " . $el_set_info[0]->id);
}
/* Get Dublin Core elements
 * Check in API configuration
 * Maximum number of API results displayed per page
 * (default 50) and adjust for returning all results!!
*/
$parameters = [];
$parameters['element_set'] = $el_set_info[0]->id;
$response = $omeka->elements->get($parameters);
$elements = Zend\Json\Json::decode($response->getBody());
if ($omeka->getDebug()) {
    debug_to_console($elements);
}

$parameters = [];
$parameters['public'] = true;
$parameters['featured'] = false;
$parameters['element_texts'] = [];

$title_element_id = -1;
$subject_element_id = -1;
$description_element_id = -1;

if (is_array($elements)) {

    foreach ($elements as $element) {

        if ($omeka->getDebug()) {
            debug_to_console($element->name . " " . $element->id, "color: red;");
        }
        switch ($element->name) {
            case "Title":
                $title_element_id = $element->id;
                $text_element = new stdClass();
                $text_element->html = false;
                $text_element->text = 'Collection created from API';
                $new_element = new stdClass();
                $new_element->id = $element->id;
                $text_element->element = $new_element;
                $parameters['element_texts'][] = $text_element;
                break;
            case "Subject":
                $subject_element_id = $element->id;
                $text_element = new stdClass();
                $text_element->html = false;
                $text_element->text = 'Test subject';
                $new_element = new stdClass();
                $new_element->id = $element->id;
                $text_element->element = $new_element;
                $parameters['element_texts'][] = $text_element;
                break;
            case "Description":
                $description_element_id = $element->id;
                $text_element = new stdClass();
                $text_element->html = false;
                $text_element->text = 'Test Description';
                $new_element = new stdClass();
                $new_element->id = $element->id;
                $text_element->element = $new_element;
                $parameters['element_texts'][] = $text_element;
                break;
        }

    }

    if ($omeka->getDebug()) {
        debug_to_console($parameters, "", "Parameters for new collection function:");
    }

    $jsonObject = Zend\Json\Json::encode($parameters, true);

    $response = $omeka->collections->post($jsonObject);

    $newCollection = Zend\Json\Json::decode($response->getBody());

    if (($newCollection!== null) && isset($newCollection->id)) {
        // Now I have new collection id anc I can create new items and associate them to new collection!
        if ($omeka->getDebug()) {
            debug_to_console($newCollection);
        }

        if ($omeka->getDebug()) {
            debug_to_console("title_element_id: ". $title_element_id, "color: red;");
            debug_to_console("subject_element_id: ". $subject_element_id, "color: red;");
            debug_to_console("description_element_id: ". $description_element_id, "color: red;");
        }

        $tags = [];
        $new_tag = new stdClass();
        $new_tag->name = 'test creation';
        $tags[] = $new_tag;

        $elements = [];
        $new_element = new stdClass();
        $new_element->text = "title number 1";
        $new_element->id = $title_element_id;
        $elements[] = $new_element;

        $new_element = new stdClass();
        $new_element->text = "subject number 1";
        $new_element->id = $subject_element_id;
        $elements[] = $new_element;

        $new_element = new stdClass();
        $new_element->text = "description number 1";
        $new_element->id = $description_element_id;
        $elements[] = $new_element;

        $response = $omeka->items->post(makeItem(1, $newCollection->id, true, false, $tags, $elements));
        // Prelevo id dell'item appena creato
        $newItem = Zend\Json\Json::decode($response->getBody());
        if (($newItem!== null) && isset($newItem->id)) {
            if ($omeka->getDebug()) {
                debug_to_console($newItem);
            }
            $response = $omeka->files->post('./files/154A_6_recto_piramide.jpg', '{"item":{"id":' . $newItem->id . '}}');
            if ($omeka->getDebug()) {
                debug_to_console(Zend\Json\Json::decode($response->getBody()));
            }
        }

        $elements = [];
        $new_element = new stdClass();
        $new_element->text = "title number 2";
        $new_element->id = $title_element_id;
        $elements[] = $new_element;

        $new_element = new stdClass();
        $new_element->text = "subject number 2";
        $new_element->id = $subject_element_id;
        $elements[] = $new_element;

        $new_element = new stdClass();
        $new_element->text = "description number 2";
        $new_element->id = $description_element_id;
        $elements[] = $new_element;

        $response = $omeka->items->post(makeItem(1, $newCollection->id, true, false, $tags, $elements));
        // Prelevo id dell'item appena creato
        $newItem = Zend\Json\Json::decode($response->getBody());
        if (($newItem!== null) && isset($newItem->id)) {
            if ($omeka->getDebug()) {
                debug_to_console($newItem);
            }
            $response = $omeka->files->post('./files/154A_6_recto_piramide.jpg', '{"item":{"id":' . $newItem->id . '}}');
            if ($omeka->getDebug()) {
                debug_to_console(Zend\Json\Json::decode($response->getBody()));
            }
        }

        $elements = [];
        $new_element = new stdClass();
        $new_element->text = "title number 3";
        $new_element->id = $title_element_id;
        $elements[] = $new_element;

        $new_element = new stdClass();
        $new_element->text = "subject number 3";
        $new_element->id = $subject_element_id;
        $elements[] = $new_element;

        $new_element = new stdClass();
        $new_element->text = "description number 3";
        $new_element->id = $description_element_id;
        $elements[] = $new_element;

        $response = $omeka->items->post(makeItem(1, $newCollection->id, true, false, $tags, $elements));
        // Prelevo id dell'item appena creato
        $newItem = Zend\Json\Json::decode($response->getBody());
        if (($newItem!== null) && isset($newItem->id)) {
            if ($omeka->getDebug()) {
                debug_to_console($newItem);
            }
            $response = $omeka->files->post('./files/154A_6_recto_piramide.jpg', '{"item":{"id":' . $newItem->id . '}}');
            if ($omeka->getDebug()) {
                debug_to_console(Zend\Json\Json::decode($response->getBody()));
            }
        }
    }

}

/*
 * Request collection with id: 8
 * */
/*
$response = $omeka->collections->get(8);
echo $response->getBody();
*/


/*
$parameters = [];
$parameters['name'] = 'TMBCore';
$response = $omeka->element_sets->get($parameters);

$response_obj = Zend\Json\Json::decode($response->getBody(), true);
if ($omeka->getDebug()) {
    debug_to_console($response_obj);
}
$element_set = -1;
if ((is_array($response_obj)) && (count($response_obj) > 0)) {
//    echo "ID: " . $response_obj[0]['id'];
    $element_set = $response_obj[0]['id'];
}
//echo $response->getBody();

/*
 * Così trovo gli elementi che appartengno all'elemento principale TMBCore
 * */
/*
if ($element_set > -1) {
    $parameters = [];
    $parameters['element_set'] = $element_set ;
    $response = $omeka->elements->get($parameters);
    //echo $response->getBody();

    $parameters = [];
    $parameters['public'] = true;
    $parameters['featured'] = false;
    $parameters['element_texts'] = [];
    $text_element = new stdClass();
    $text_element->html = false;
    $text_element->text = 'Collection created from API';
    $element = new stdClass();
    $element->id = 1;
    $text_element->element = $element;
    $parameters['element_texts'][] = $text_element;
}
*/

/*
 * Creo un nuovo item
 * */

/*
$item = new stdClass();

$item_type = new stdClass();
$item_type->id = 1;
$item->item_type = $item_type;

$collection = new stdClass();
$collection->id = 8;
$item->collection = $collection;

$item->public = true;
$item->featured = false;

$tags = [];
$new_tag = new stdClass();
$new_tag->name = 'foo';
$tags[] = $new_tag;
$new_tag = new stdClass();
$new_tag->name = 'bar';
$tags[] = $new_tag;
$item->tags = $tags;

$element_texts = [];
$new_element_text = new stdClass();
$new_element_text->html = false;
$new_element_text->text = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.';
$element = new stdClass();
$element->id = 1;
$new_element_text->element = $element;
$element_texts[] = $new_element_text;
$item->element_texts = $element_texts;

error_log(print_r($item, true));
$jsonObject = Zend\Json\Json::encode($item, true);
error_log("****");
error_log($jsonObject);

$response = $omeka->items->post($jsonObject);
echo $response->getBody();
*/

/*
 * Associazione di un file ad un dato item
 * */
/*
$response = $omeka->files->post('./files/154A_6_recto_piramide.jpg', '{"item":{"id":981}}');
echo $response->getBody();
*/


/*
$response = $omeka->oa->get(987);
echo $response->getBody();
*/

// ---------------------------------------------------------------------

/*
$response = $omeka->resources->get();
echo $response->getBody();
*/

/*
// GET /items/:id
$response = $omeka->items->get(975);
echo $response->getBody();

// GET /items
$response = $omeka->items->get();
echo $response->getBody();

// POST /items
$response = $omeka->items->post('{}');
echo $response->getBody();

// POST /files
// Note the different signature. You can set callbacks to the client that handle
// custom request behavior. This callback is set in the constructor, but others
// can be set suing ZendService\Omeka\Omeka::setCallback().
$response = $omeka->files->post('/path/to/file', '{"item":{"id":1}}');
echo $response->getBody();

// PUT /items/:id
$response = $omeka->items->put(1, '{}');
echo $response->getBody();

// DELETE /items/:id
$response = $omeka->items->delete(1);
echo $response->getBody();
*/