<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 21/07/17
 * Time: 12:07
 */

use Zend\Json\Json;

/**
 * Simple helper to debug to the console
 *
 * @param $data object, array, string $data
 * @param $style string  Optional a css style.
 * @param $context string  Optional a description.
 *
 * @return string
 */
function debug_to_console( $data, $style = '', $context = '' ) {

    // Buffering to solve problems frameworks, like header() in this and not a solid return.
    ob_start();

    if ($context !== '') {
        $output = 'console.info( \'' . $context . ':\' );';
    } else {
        $output = '';
    }

    if ($style !== '') {
        $output .= 'console.log("%c ' . $data . '", "' . $style . '");';

    } else {
        $output .= 'console.log(' . json_encode($data) . ');';
    }
    $output  = sprintf( '<script>%s</script>', $output );

    echo $output;
}

/*
function makeItem(
    $element_type_id, $collection_id, $public, $featured, $tags = [], $elements = []
) {

    $item = new stdClass();

    $item_type = new stdClass();
    $item_type->id = $element_type_id;
    $item->item_type = $item_type;

    $collection = new stdClass();
    $collection->id = $collection_id;
    $item->collection = $collection;

    $item->public = $public;
    $item->featured = $featured;

    $item->tags = $tags;

    $element_texts = [];
    foreach ($elements as $element) {
        $new_element_text = new stdClass();
        $new_element_text->html = false;
        $new_element_text->text = $element->text;
        $new_element = new stdClass();
        $new_element->id = $element->id;
        $new_element_text->element = $new_element;
        $element_texts[] = $new_element_text;
    }
    $item->element_texts = $element_texts;

    $jsonObject = Zend\Json\Json::encode($item, true);
    return $jsonObject;

}*/