<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 26/10/17
 * Time: 17:29
 */

require_once (__DIR__ . '/../constants.php');
require_once (__DIR__ . '/../TMBProcessor.php');
require_once (__DIR__ . '/../httprequests/functions.php');
require_once (__DIR__ . '/../api/config/database.php');
require_once (__DIR__ . '/../api/objects/log.php');

use Ramsey\Uuid\Uuid;

require_once ("OperationsManagement.php");

/*
define ('INFO_FIELDS_ARRAY', include(__DIR__ . '/fields/infoFields.php'));
define ('TC_FIELDS_ARRAY', include(__DIR__ . '/fields/tcFields.php'));
*/

class ImportOperations extends OperationsManagement {

    public $inputFolderPath = '';
    public $outputFolderPath = '';

    public $syncOmeka = false;
    public $createPublicItemsAndCollections = false;
    public $forceProcedure = false;
    public $dryMode = false;
    public $createOriNameFromID = true;
    public $itemTitleField = '';
    public $onlyCheckNormalization = false;
    public $importFilze = false;

    private $ct_update_filenamePointer = null;

    public function scanForImport() {

        $dir = $this->inputFolderPath;
        $this->wsLogMessage("Start analyzing folder " . $dir . "...");

        $filesInfo = new StdClass();
        $filesInfo->tifFilesCount = 0;

        $this->scan($dir, $filesInfo);

        $this->wsLogMessage("Analysis of folder " . $dir . " finished");
        $this->wsLogMessage("<b>There are " . $filesInfo->tifFilesCount . " images to convert</b>");
        $this->wsMessageDone("Analysis of folder " . $dir . " finished");

    }

    public function analyzeErrors() {

        $dir = $this->inputFolderPath;
        $this->wsLogMessage("Start analyzing errors on folder " . $dir . "...");

        $this->scanForErrors($dir);
        $err_num = 0;
        $this->scanForTiffFiles($dir, $err_num );

        $this->wsLogMessage("Check finished");
        $this->wsMessageDone("Error analysis of folder " . $dir . " finished");

    }

    public function analyzeFolderForImport() {

        $dir = $this->inputFolderPath;
        $this->wsLogMessage("Start analyzing folder " . $dir . "...");

        if ($this->importFilze) {

            $this->wsLogMessage("");
            $this->wsLogMessage("---------- Check _info files ----------");
            $this->dryMode = true;
            $this->scanForFilzeImport($dir);

        } else {
            $this->wsLogMessage("");
            $this->wsLogMessage("---------- Check if images listed on _TC file are present on folder ----------");
            $this->scanTcfiles($dir);

            $this->wsLogMessage("");
            $this->wsLogMessage("---------- Check if _TC and _INFO files are present on folder ----------");
            $err_num = 0;
            $this->scanForTiffFiles($dir, $err_num);

            $this->wsLogMessage("");
            $this->wsLogMessage("Check finished");
            $this->wsMessageDone("Analysis of folder " . $dir . " finished");
        }

    }

    public function import() {

        $go_on = true;

        $this->wsLogMessage($this->syncOmeka ? "Omeka syncronization is ACTIVE" : "Omeka syncronization is NOT ACTIVE");
        $this->wsLogMessage($this->forceProcedure ? "Force procedure is ACTIVE" : "Force procedure is NOT ACTIVE");
        $this->wsLogMessage($this->dryMode ? "Simulation is ACTIVE" : "Simulation is NOT ACTIVE");
        $this->wsLogMessage($this->importFilze ? "Import Filze is ACTIVE" : "Import Filze is NOT ACTIVE");

        if (trim($this->inputFolderPath) === '') {
            $this->wsLogMessage("Error! Input folder is not specified!");
            $this->wsMessageDone("Error! Input folder is not specified!");
            $go_on = false;
        }

        if (!file_exists($this->inputFolderPath)) {
            $this->wsLogMessage('<font color="#8b0000">Input folder not exists!</font>');
            $this->wsMessageDone("Input folder not exists!");
            $go_on = false;
        }

        $dir = $this->inputFolderPath;
        $err_num = 0;

        if (!$this->importFilze) {
            $this->scanForTiffFiles($dir, $err_num);
        }

        if ($go_on) {
            $this->wsLogMessage("Init database. Waiting...");
            $database = new Database();
            $db = $database->getConnection();
            if ($db->status !== 'active') {
                $this->wsLogMessage('<font color="#8b0000">' . $db->status . '</font>');
                $this->wsMessageDone("Procedure aborted!");
            } else {
                $this->wsLogMessage("Opened database successfully");

                $record = new Log($db->PDO);
                $resultInfo = $record->createTable();
                $this->wsLogMessage($resultInfo);

                if (!$this->importFilze) {
                    $operation_uuid = $this->convertAndUpload();
                } else {
                    $operation_uuid = $this->convertAndUploadFilze();
                }

                if ($err_num > 0) {
                    $this->wsUpdateStatistics($operation_uuid, "Errors found", $err_num);
                }

                $logMessage = "Import finished successfully.";
                $this->wsLogMessage('<font color="#006400">' . $logMessage . '</font>');
                $record = new Log(null);
                $record->operation_uuid = $operation_uuid;
                $record->operation = 'Import';
                $record->description = $logMessage;

                $resultInfo = callApi_createLog($record);
                if (!strpos($resultInfo, 'cURL Error')) {
                    //$resultInfo = json_decode($resultInfo);
                    //$operations->getServer()->wsSend($clientID, $resultInfo->message);
                } else {
                    $this->wsLogMessage($resultInfo);
                }

                $this->wsMessageDone($logMessage);
            }
        } else {
            $this->wsMessageDone("Procedure aborted!");
        }

    }

    private function scan($dir = '', $filesInfo = null){

        if ($dir === '') {
            $dir = rtrim($this->inputFolderPath, '/');
        }

        if ($filesInfo === null) {
            $filesInfo = new StdClass();
            $filesInfo->tifFilesCount = 0;
        }

        // Is there actually such a folder/file?
        if(file_exists($dir)){

            foreach(scandir($dir) as $f) {

                if(!$f || $f[0] == '.') {
                    continue; // Ignore hidden files
                }

                if(is_dir($dir . '/' . $f)) {

                    $this->scan($dir . '/' . $f, $filesInfo);

                } else {

                    // It is a file
                    if (strpos($f, '_' . INFO_FILE . 'xls') !== false || strpos($f, '_' . INFO_FILE . 'xlsx') !== false) {

                        $this->wsLogMessage('<font color="#006400">' . "Metadata file found on folder " . $dir . '</font>');

                        // Verifica il numero di files tif presenti nella cartella:
                        $files = glob($dir . '/*.tif');
                        if ( $files !== false ) {
                            $tif_filecount = count( $files );
                            $this->wsLogMessage("<b>Tif files on folder: " . $tif_filecount . "</b>");
                            $filesInfo->tifFilesCount=$filesInfo->tifFilesCount+$tif_filecount;
                        } else {
                            $this->wsLogMessage('<font color="#8b0000">' . "There are not tif files on the folder!" . '</font>');
                        }

                    }

                }
            }

        }

    }

    private function scanForTiffFiles($dir = '', &$err_num) {

        if ($dir === '') {
            $dir = rtrim($this->inputFolderPath, '/');
        }

        if(file_exists($dir)) {

            foreach(scandir($dir) as $f) {

                if(!$f || $f[0] == '.') {
                    continue; // Ignore hidden files
                }

                if(is_dir($dir . '/' . $f)) {

                    $currentDir = $dir . '/' . $f;
                    $files = glob($currentDir . '/*.tif');
                    if (( $files !== false ) && (count($files) > 0)) {

                        // Tiff founded, check if _info e _tc are present!!

                        $info_file_xls_old = $currentDir . '/' . $f . '_' . INFO_FILE . '.xls';
                        $info_file_xls_new = $currentDir . '/' . $f . '_' . INFO_FILE . '.xlsx';

                        if (!file_exists($info_file_xls_old) && !file_exists($info_file_xls_new)) {
                            $error_description = "File " . $info_file_xls_old . " or " . $info_file_xls_new . " not found!";
                            $this->wsLogMessage('<font color="#8b0000">' . $error_description . '</font>');
                            $this->wsAddError('Metadata presence', $error_description);
                            $err_num++;
                        }

                        $tc_file_xls_old = $currentDir . '/' . $f . '_' . TC_FILE . '.xls';
                        $tc_file_xls_new = $currentDir . '/' . $f . '_' . TC_FILE . '.xlsx';

                        if (!file_exists($tc_file_xls_old) && !file_exists($tc_file_xls_new)) {
                            $error_description = "File " . $tc_file_xls_old . " or " . $tc_file_xls_new . " not found!";
                            $this->wsLogMessage('<font color="#8b0000">' . $error_description . '</font>');
                            $this->wsAddError('Metadata presence', $error_description);
                            $err_num++;
                        }

                    }
                    $this->scanForTiffFiles($dir . '/' . $f, $err_num);

                }
            }

        }

    }

    private function scanForErrors($dir = '') {

        if ($dir === '') {
            $dir = rtrim($this->inputFolderPath, '/');
        }

        // Is there actually such a folder/file?
        if(file_exists($dir)){

            foreach(scandir($dir) as $f) {

                if(!$f || $f[0] == '.') {
                    continue; // Ignore hidden files
                }

                if(is_dir($dir . '/' . $f)) {

                    $this->scanForErrors($dir . '/' . $f);

                } else {

                    // It is a file
                    if (strpos($f, "errors.json") !== false) {

                        $str = file_get_contents($dir . '/' . $f);
                        $json = json_decode($str, false);

                        if (isset($json->errors)) {

                            $this->wsLogMessage('<font color="#006400">' . "Errors file found on folder " . $dir . '</font>');

                            foreach ($json->errors as $error) {
                                $this->wsAddError($error->errorType, $error->errorDescription);
                            }
                        }

                    }

                }
            }

        }

    }

    private function scanTcfiles($dir = '') {

        if ($dir === '') {
            $dir = rtrim($this->inputFolderPath, '/');
        }

        // Is there actually such a folder/file?
        if(file_exists($dir)){

            foreach(scandir($dir) as $f) {

                if(!$f || $f[0] == '.') {
                    continue; // Ignore hidden files
                }

                if(is_dir($dir . '/' . $f)) {

                    $this->scanTcfiles($dir . '/' . $f);

                } else {

                    // It is a file

                    $signatureFolder = basename($dir);
                    $inputMetaDataTCFilePath =
                        $dir . '/' . $signatureFolder . '_' . TC_FILE;

                    if ((strpos($f, $signatureFolder . '_' . TC_FILE . '.xlsx') !== false) || (strpos($f, $signatureFolder . '_' . TC_FILE . '.xls') !== false)) {

                        // $this->wsLogMessage("Check file: " . $dir . '/' . $f);
                        // This line is the same of the previous one
                        // $this->wsLogMessage("Check file: " . $inputMetaDataTCFilePath);
                        $excelReader = 'Excel2007';
                        if (file_exists($inputMetaDataTCFilePath . '.xlsx')) {
                            $inputMetaDataTCFilePath = $inputMetaDataTCFilePath . '.xlsx';
                        } else if (file_exists($inputMetaDataTCFilePath . '.xls')) {
                            $inputMetaDataTCFilePath = $inputMetaDataTCFilePath . '.xls';
                            $excelReader = 'Excel5';
                        }

                        /*
                         * Check if not tif files are present on folder do not elaborate file _tc
                         * */
                        $files = glob($dir . '/*.tif');
                        if (( $files === false ) || (count($files) <= 0)) {
                            $this->wsLogMessage('<font color="#006400">' . "File with tc " . $inputMetaDataTCFilePath . " founded but not tif files are present on folder " . $dir . "!" . '</font>');
                        } else {
                            // Analyze excel file
                            try {

                                $cacheMethod = PHPExcel_CachedObjectStorageFactory:: cache_to_phpTemp;
                                $cacheSettings = array(' memoryCacheSize ' => '8MB');
                                PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);

                                $objReader = PHPExcel_IOFactory::createReader($excelReader);
                                $objReader->setReadDataOnly(true);

                                if (TC_METADATAWORKSHEET !== '') {
                                    $objReader->setLoadSheetsOnly(array(TC_METADATAWORKSHEET));
                                }
                                $objectPHPExcel = $objReader->load($inputMetaDataTCFilePath);

                                $arrayPHPExcel = $objectPHPExcel->getActiveSheet()->toArray();

                                // Use array filter to delete blank columns
                                $arrayPHPExcel = array_filter(array_map('array_filter', $arrayPHPExcel));

                                $columnIdentifierArray = $arrayPHPExcel[0];

                                // Number of columns to consider is given by title colums
                                $columns_number = count($columnIdentifierArray);

                                for ($row_idx = 1; $row_idx < $objectPHPExcel->getActiveSheet()->getHighestRow(); $row_idx++) {

                                    $outputFileName = $row_idx;

                                    // Building template JSON stdClass object
                                    $activeObjectJSON = new stdClass();
                                    $activeObjectJSON->metadata = new stdClass();

                                    for ($col_idx = 0; $col_idx < $columns_number; $col_idx++) {

                                        if ($col_idx < count($columnIdentifierArray)) {
                                            $titleColumn = trim($columnIdentifierArray[$col_idx]);
                                            if (isset($arrayPHPExcel[$row_idx][$col_idx]) && trim($arrayPHPExcel[$row_idx][$col_idx]) !== '') {
                                                $dataColumn = $arrayPHPExcel[$row_idx][$col_idx];
                                            } else {
                                                $dataColumn = "";
                                            }

                                            if ($titleColumn === 'id') {
                                                $activeObjectJSON->{$titleColumn} = $dataColumn;
                                            } else if (in_array($titleColumn, TC_FIELDS_ARRAY)) {
                                                $activeObjectJSON->metadata->{$titleColumn} = $dataColumn;
                                            } else {
                                                echo "On file " . $inputMetaDataTCFilePath . ":\n";
                                                echo "\t!INDEX: \"" . $titleColumn . "\" NOT SUPPORTED!\n";
                                            }
                                        }

                                    }

                                    if (!isset($activeObjectJSON->id)) {
                                        $this->wsLogMessage('<font color="#006400">' . 'Column "id" not defined on file: ' . $inputMetaDataTCFilePath . '!' . '</font>');
                                    } else {

                                        if (($this->createOriNameFromID) && ($activeObjectJSON->id !== '')) {
                                            $activeObjectJSON->metadata->originalFileName = str_pad($activeObjectJSON->id, 4, "0", STR_PAD_LEFT) . ".tif";
                                        }

                                        if ($activeObjectJSON->id === '') {
                                            // If I am on first row then insert blank page
                                            if ($row_idx === 1) {
                                                $activeObjectJSON->metadata->originalFileName = BLANK_PAGE_NAME . ".tif";
                                            } else {
                                                $activeObjectJSON->metadata->originalFileName = WHITE_PAPER_NAME . ".tif";
                                            }
                                        }

                                        // At this point check image and if present convert it and then make the json file
                                        $singleFile = rtrim($dir, '/') . '/' . $activeObjectJSON->metadata->originalFileName;

                                        // If have a white paper and file not exists I take the default
                                        if (($activeObjectJSON->metadata->originalFileName === WHITE_PAPER_NAME . ".tif") && (!file_exists($singleFile))) {
                                            $singleFile = "images/" . WHITE_PAPER_NAME . ".tif";
                                        }
                                        // If have a blank page and file not exists I take the default
                                        if (($activeObjectJSON->metadata->originalFileName === BLANK_PAGE_NAME . ".tif") && (!file_exists($singleFile))) {
                                            $singleFile = "images/" . BLANK_PAGE_NAME . ".tif";
                                        }

                                        if (is_dir($singleFile) || !file_exists($singleFile)) {
                                            $this->wsLogMessage('<font color="#006400">' . 'File ' . $singleFile . ' is a folder or not exist!' . '</font>');
                                        }

                                        $fileExtension = strtolower(pathinfo($singleFile, PATHINFO_EXTENSION));
                                        if (!in_array($fileExtension, SUPPORTED_IMG_FILE_TYPES)) {
                                            $this->wsLogMessage('<font color="#006400">' . 'File ' . $singleFile . 'has the extension ' . $fileExtension . ' that is not supported!' . '</font>');
                                        }

                                    }

                                }

                            } catch (Exception $e) {
                                echo "** Error on scanTcfiles on folder: " . $dir . " - exception: " . $e->getMessage() . " **\n";
                            }
                        }

                    }

                }
            }

        }

    }

    private function scanForFilzeImport($dir = '', $tmbprocessor = null, $operation_uuid = '') {

        if ($dir === '') {
            $dir = rtrim($this->inputFolderPath, '/');
        }
        $this->wsLogMessage("*** Import 'Filze' on folder " . $dir . " ***");

        // Is there actually such a folder/file?
        if(file_exists($dir)){

            foreach(scandir($dir) as $f) {

                if(!$f || $f[0] == '.') {
                    continue; // Ignore hidden files
                }

                if(is_dir($dir . '/' . $f)) {

                    $pattern = "/(-b-)(\d+(bis)?)-(\S+)/";
                    preg_match($pattern, basename($dir. '/' . $f), $result);

                    // $result[2] contiene la signature
                    if (count($result) > 2) {
                        $signatureFolder = $result[2];
                        if (trim($signatureFolder) !== '') {
                            $inputMetaDataInfoFilePath =
                                $dir . '/' . $f . '/' . $signatureFolder . '_' . INFO_FILE;

                            $this->wsLogMessage("I have to found: " . $inputMetaDataInfoFilePath . ".xlsx or " . $inputMetaDataInfoFilePath . ".xls");

                            $excelReader = '';
                            if (file_exists($inputMetaDataInfoFilePath . '.xlsx')) {
                                $excelReader = 'Excel2007';
                                $inputMetaDataInfoFilePath = $inputMetaDataInfoFilePath . '.xlsx';
                            } else if (file_exists($inputMetaDataInfoFilePath . '.xls')) {
                                $inputMetaDataInfoFilePath = $inputMetaDataInfoFilePath . '.xls';
                                $excelReader = 'Excel5';
                            }

                            if (trim($excelReader !== '')) {

                                $proceed = true;

                                $this->wsLogMessage("inputMetaDataInfoFilePath: " . $inputMetaDataInfoFilePath);
                                $this->wsLogMessage("excelReader: " . $excelReader);

                                if (!$this->dryMode) {
                                    $inputProcessedFilesPath =
                                        $dir . '/' . $f . '/' . $signatureFolder . '_' . DONE_FILE;
                                    $inputOmekaInfoPath =
                                        $dir . '/' . $f . '/' . $signatureFolder . '_' . OMEKA_INFO_FILE;

                                    if (!file_exists($inputProcessedFilesPath) || $this->forceProcedure) {

                                        $outputFolder = $dir . '/' . $f . '_output/';

                                        // Building output paths
                                        $outputMetadataInfoFilePath =
                                            $outputFolder . $signatureFolder . '_info.json';

                                        // Deleting old info.json file
                                        if (file_exists($outputMetadataInfoFilePath) && !$this->dryMode) {
                                            unlink($outputMetadataInfoFilePath);
                                        }

                                        // Removing old output Folder from system if existing
                                        if (file_exists($outputFolder) && !$this->dryMode) {
                                            system('rm -rf ' . escapeshellarg($outputFolder));
                                        }

                                        // Building new output Folder
                                        if (!$this->dryMode) {
                                            mkdir($outputFolder, 0777, true);
                                        }

                                    } else {

                                        $proceed = false;

                                        $this->wsLogMessage('<font color="#ff8c00">Folder ' . basename($dir. '/' . $f) . ' already processed!</font>');
                                        $record = new Log(null);
                                        $record->operation_uuid = $operation_uuid;
                                        $record->operation = 'Import';
                                        $record->description = 'Folder ' . basename($dir. '/' . $f) . ' already processed!';
                                        $resultInfo = callApi_createLog($record);
                                        if (!strpos($resultInfo, 'cURL Error')) {
                                        } else {
                                            $this->wsLogMessage($resultInfo);
                                        }

                                    }

                                }

                                if ($proceed) {

                                    if (!$this->dryMode) {

                                        $newCollection = $tmbprocessor->infoProcessor(
                                            $this,
                                            $operation_uuid,
                                            $inputMetaDataInfoFilePath,
                                            $outputMetadataInfoFilePath,
                                            $inputOmekaInfoPath,
                                            $this->dryMode,
                                            $this->createPublicItemsAndCollections,
                                            true
                                        );

                                        if ($newCollection !== null && isset($newCollection->id)) {
                                            $omekaInfoFilePointer = fopen($inputOmekaInfoPath, 'w');

                                            $dataObject = new stdClass();
                                            $collectionObject = new stdClass();
                                            $collectionObject->id = $newCollection->id;
                                            $collectionObject->title = $newCollection->title;
                                            $collectionObject->url = $newCollection->url;
                                            $collectionObject->added = $newCollection->added;
                                            $collectionObject->modified = $newCollection->modified;
                                            $dataObject->collection = $collectionObject;

                                            fwrite($omekaInfoFilePointer, json_encode($dataObject, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
                                            fclose($omekaInfoFilePointer);
                                        }

                                    } else {

                                        try {

                                            $cacheMethod = PHPExcel_CachedObjectStorageFactory:: cache_to_phpTemp;
                                            $cacheSettings = array(' memoryCacheSize ' => '8MB');
                                            PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);

                                            $objReader = PHPExcel_IOFactory::createReader($excelReader);
                                            $objReader->setReadDataOnly(true);

                                            if (INFO_METADATAWORKSHEET !== '') {
                                                $objReader->setLoadSheetsOnly(array(INFO_METADATAWORKSHEET));
                                            }


                                            $objectPHPExcel = $objReader->load($inputMetaDataInfoFilePath);

                                            $arrayPHPExcel = $objectPHPExcel->getActiveSheet()->toArray();

                                            // Use array filter to delete blank columns
                                            $arrayPHPExcel = array_filter(array_map('array_filter', $arrayPHPExcel));

                                            // echo "** arrayPHPExcel: " . print_r($arrayPHPExcel, true);

                                            $columnIdentifierArray = $arrayPHPExcel[0];

                                            // Number of columns to consider is given by title colums
                                            $columns_number = count($columnIdentifierArray);

                                            for ($row_idx = 1; $row_idx < $objectPHPExcel->getActiveSheet()->getHighestRow(); $row_idx++) {

                                                $outputFileName = $row_idx;

                                                // Building template JSON stdClass object
                                                $activeObjectJSON = new stdClass();
                                                $activeObjectJSON->metadata = new stdClass();

                                                for ($col_idx = 0; $col_idx < $columns_number; $col_idx++) {

                                                    if ($col_idx < count($columnIdentifierArray)) {
                                                        $titleColumn = trim($columnIdentifierArray[$col_idx]);
                                                        if (isset($arrayPHPExcel[$row_idx][$col_idx]) && trim($arrayPHPExcel[$row_idx][$col_idx]) !== '') {
                                                            $dataColumn = $arrayPHPExcel[$row_idx][$col_idx];
                                                        } else {
                                                            $dataColumn = "";
                                                        }

                                                        if (in_array($titleColumn, INFO_FIELDS_ARRAY)) {
                                                            $activeObjectJSON->metadata->{$titleColumn} = $dataColumn;
                                                        } else {
                                                            echo "On file " . $inputMetaDataInfoFilePath . ":\n";
                                                            echo "\t!INDEX: \"" . $titleColumn . "\" NOT SUPPORTED!\n";
                                                        }
                                                    }

                                                }

                                            }

                                            $objectPHPExcel->disconnectWorksheets();
                                            unset($objectPHPExcel);

                                        } catch (Exception $e) {
                                            $this->wsLogMessage('<font color="#ff8c00">' . "** Error on scanForFilzeImport on folder: " . $dir . " - exception: " . $e->getMessage() . ' **</font>');
                                        }

                                        // Se non ho dei valori specificati per le Filze ho dei default:
                                        if ((!isset($activeObjectJSON->metadata->maintenanceagency)) || (trim($activeObjectJSON->metadata->maintenanceagency) === '')) {
                                            $activeObjectJSON->metadata->maintenanceagency = 'SIASVe';
                                            $this->wsLogMessage("Impostato campo maintenanceagency con il valore di default " . $activeObjectJSON->metadata->maintenanceagency);
                                        }

                                        if ((!isset($activeObjectJSON->metadata->recordid)) || (trim($activeObjectJSON->metadata->recordid) === '')) {
                                            $activeObjectJSON->metadata->recordid = 'IT ASVe 0445 010 001 001';
                                            $this->wsLogMessage("Impostato campo recordid con il valore di default " . $activeObjectJSON->metadata->recordid);
                                        }

                                        if ((!isset($activeObjectJSON->metadata->series)) || (trim($activeObjectJSON->metadata->series) === '')) {
                                            $activeObjectJSON->metadata->series = 'Redecima 1740 Condizioni di decima. Filze';
                                            $this->wsLogMessage("Impostato campo series con il valore di default " . $activeObjectJSON->metadata->series);
                                        }

                                        if ((!isset($activeObjectJSON->metadata->level)) || (trim($activeObjectJSON->metadata->level) === '')) {
                                            $activeObjectJSON->metadata->level = 'UA';
                                            $this->wsLogMessage("Impostato campo level con il valore di default " . $activeObjectJSON->metadata->level);
                                        }

                                        if ((!isset($activeObjectJSON->metadata->physdesc)) || (trim($activeObjectJSON->metadata->physdesc) === '')) {
                                            $activeObjectJSON->metadata->physdesc = 'carta';
                                            $this->wsLogMessage("Impostato campo physdesc con il valore di default " . $activeObjectJSON->metadata->physdesc);
                                        }

                                        if ((!isset($activeObjectJSON->metadata->creator)) || (trim($activeObjectJSON->metadata->creator) === '')) {
                                            $activeObjectJSON->metadata->creator = 'Dieci savi alle decime in Rialto';
                                            $this->wsLogMessage("Impostato campo creator con il valore di default " . $activeObjectJSON->metadata->creator);
                                        }

                                        if ((!isset($activeObjectJSON->metadata->date_year_start)) || (trim($activeObjectJSON->metadata->date_year_start) === '')) {
                                            $activeObjectJSON->metadata->date_year_start = '1740';
                                            $this->wsLogMessage("Impostato campo date_year_start con il valore di default " . $activeObjectJSON->metadata->date_year_start);
                                        }
                                    }

                                    $infoObject = null;
                                    if (file_exists($outputMetadataInfoFilePath)) {
                                        $str = file_get_contents($outputMetadataInfoFilePath);
                                        $infoObject = json_decode($str, false);
                                    }

                                    $this->wsLogMessage("Processing MetaData and relative images ...");

                                    $this->scanForFilzeImportTcFiles(
                                        $outputFolder,
                                        $dir . '/' . $f,
                                        $tmbprocessor,
                                        $operation_uuid,
                                        $infoObject,
                                        null,
                                        $newCollection
                                    );

                                }
                            }

                        }
                    } else {
                        $this->scanForFilzeImport($dir . '/' . $f);
                    }

                    if (!$this->dryMode) {
                        $doneFilePointer = fopen($inputProcessedFilesPath, 'w');
                        fwrite($doneFilePointer, $inputProcessedFilesPath . " processed with success on " . time());
                        fclose($doneFilePointer);
                    }

                }

            }

        }

    }

    private function scanForFilzeImportTcFiles($outputFolder, $dir = '', $tmbprocessor = null, $operation_uuid = '', $infoObject = null, $collection = null, $parent_collection = null) {

        if (file_exists($dir)) {

            foreach (scandir($dir) as $f) {

                if (!$f || $f[0] == '.') {
                    continue; // Ignore hidden files
                }

                if (is_dir($dir . '/' . $f)) {

                    if ($f !== '@eaDir') {
                        $this->wsLogMessage("I have to create also collection relative to folder: " . $dir . '_output/' . $f);

                        if (!$this->dryMode) {
                            mkdir($dir . '_output/' . $f, 0777, true);
                            $this->wsLogMessage("Folder: " . $dir . '_output/' . $f . " created.");
                        }

                        if (isset($infoObject) && isset($infoObject->metadata)) {

                            $inputProcessedFilesPath =
                                $dir . '/' . $f . '/' . basename($f) . '_' . DONE_FILE;
                            $inputOmekaInfoPath =
                                $dir . '/' . $f . '/' . basename($f) . '_' . OMEKA_INFO_FILE;

                            $proceed = true;
                            if (!file_exists($inputProcessedFilesPath) || $this->forceProcedure) {
                                // Building output paths
                                $outputMetadataInfoFilePath =
                                    $outputFolder . '/' . basename($f) . '/' . basename($f) . '_info.json';
                            } else {
                                $proceed = false;
                            }

                            if ($proceed) {
                                $infoObject->metadata->code = basename($f);

                                $newCollection = $tmbprocessor->infoProcessor(
                                    $this,
                                    $operation_uuid,
                                    '',
                                    $outputMetadataInfoFilePath,
                                    $inputOmekaInfoPath,
                                    $this->dryMode,
                                    $this->createPublicItemsAndCollections,
                                    true,
                                    $infoObject
                                );

                                if ($newCollection !== null && isset($newCollection->id)) {
                                    $omekaInfoFilePointer = fopen($inputOmekaInfoPath, 'w');

                                    $dataObject = new stdClass();
                                    $collectionObject = new stdClass();
                                    $collectionObject->id = $newCollection->id;
                                    $collectionObject->title = $newCollection->title;
                                    $collectionObject->url = $newCollection->url;
                                    $collectionObject->added = $newCollection->added;
                                    $collectionObject->modified = $newCollection->modified;
                                    $dataObject->collection = $collectionObject;

                                    fwrite($omekaInfoFilePointer, json_encode($dataObject, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
                                    fclose($omekaInfoFilePointer);

                                    // Write update file for collection tree
                                    $sql_text = "UPDATE `omeka_collection_trees` SET `parent_collection_id`= " . $parent_collection->id . " WHERE `collection_id` = " . $newCollection->id . ";\n";
                                    fwrite($this->ct_update_filenamePointer, $sql_text);
                                }
                            }
                        }

                        $this->scanForFilzeImportTcFiles($outputFolder, $dir . '/' . $f, $tmbprocessor, $operation_uuid, $infoObject, $newCollection, $parent_collection);
                    }

                } else {

                    $fileExtension = strtolower(pathinfo($f, PATHINFO_EXTENSION));
                    if (in_array($fileExtension, SUPPORTED_IMG_FILE_TYPES)) {

                        $pattern = "/(-b-)(\d+(bis)?)-(\S+)-(\d+)_(\d+)_(\w+)/";
                        preg_match($pattern, basename($f), $result);

                        if (!$this->dryMode) {

                            $singleFile = $dir . '/' . $f;
                            $outputFile = $outputFolder . basename($dir) . '/' . $result[6] . '.jpg';
                            $outputMetadataTCFilePath = $outputFolder . basename($dir) . '/' . $result[6] . ".json";

                            $imgConversionReturnObj = $tmbprocessor->imageProcessor(
                                $this,
                                $singleFile,
                                $outputFile,
                                $this->dryMode
                            );

                            if ($this->dryMode) {
                                $message = ">>DRYMODE<< Image " . $singleFile . " should be converted in " . $outputFile;
                                $this->wsLogMessage('<font color="#006400">' . $message . '</font>');
                            }

                            if ($imgConversionReturnObj->returnStatus === 'no') {

                                $errorObjectJSON = new stdClass();
                                $errorObjectJSON->errorType = 'File conversion error';
                                $errorObjectJSON->errorDescription = $imgConversionReturnObj->returnDescription;
                                $errors [] = $errorObjectJSON;

                                $this->wsLogMessage('<font color="#8b0000">' . 'File conversion error: ' . $imgConversionReturnObj->returnDescription . '</font>');
                                $this->wsUpdateStatistics($operation_uuid, "Errors found", 1);
                                $this->wsAddError($errorObjectJSON->errorType, $errorObjectJSON->errorDescription);

                                $record = new Log(null);
                                $record->operation_uuid = $operation_uuid;
                                $record->operation = 'Import';
                                $record->description = 'File conversion error: ' . $imgConversionReturnObj->returnDescription;

                                $resultInfo = callApi_createLog($record);
                                if (!strpos($resultInfo, 'cURL Error')) {
                                } else {
                                    $this->wsLogMessage($resultInfo);
                                }

                            } else {

                                // Building output file path
                                // Opening in write mode output file pointer
                                $filePointer = fopen($outputMetadataTCFilePath, 'w');
                                // Encode JSON into file
                                $activeObjectJSON = new stdClass();
                                $activeObjectJSON->metadata = new stdClass();

                                $activeObjectJSON->{'manifest_id'} = Uuid::uuid4()->toString();
                                // Url originale del file - in questo caso va composto in base a dove vengono caricate le immagini su omeka
                                // $activeObjectJSON->metadata->{'sourceUrl'} = "";
                                $activeObjectJSON->metadata->{'filename'} = $result[6] . '.jpg';
                                $activeObjectJSON->metadata->{'fileMD5'} = md5_file($outputFile);

                                $activeObjectJSON->{'width'} = $imgConversionReturnObj->width;
                                $activeObjectJSON->{'height'} = $imgConversionReturnObj->height;

                                $activeObjectJSON->metadata->{'exifData'} = $imgConversionReturnObj->exifData;

                                $activeObjectJSON->metadata->cartulazione1 = "moderna";
                                $activeObjectJSON->metadata->originalFileName = basename($singleFile);

                                $activeObjectJSON->metadata->id = $result[6];
                                $activeObjectJSON->metadata->cartulazioneProgression1 = $result[7];

                                fwrite($filePointer, json_encode($activeObjectJSON));

                                $tmbprocessor->tcProcessor(
                                    $this,
                                    $operation_uuid,
                                    ''/*$inputFolder*/,
                                    ''/*$current_folder*/,
                                    $outputFolder . basename($dir),
                                    ''/*$inputMetaDataTCFilePath*/,
                                    ($collection !== null && isset($collection->title)) ? $collection->title : '',
                                    ($collection !== null && isset($collection->id)) ? $collection->id : '',
                                    ($collection !== null && isset($collection->exifData)) ? $collection->exifData : '',
                                    $this->dryMode,
                                    $this->createOriNameFromID,
                                    $this->itemTitleField,
                                    $this->createPublicItemsAndCollections,
                                    $activeObjectJSON
                                );

                            }

                        } else {
                            $this->wsLogMessage("id: " . $result[6]);
                            $this->wsLogMessage("originalFileName: " . $f);
                            $this->wsLogMessage("cartulazioneProgression1: " . $result[7]);
                            $this->wsLogMessage("I have to consider " . $f . " file belogs to collection " . $result[2]);
                        }

                    }

                }

            }

        }

    }

    private function convertAndUpload() {

        $inputFolder = rtrim($this->inputFolderPath, '/');

        $operation_uuid = Uuid::uuid4()->toString();

        $di = new RecursiveDirectoryIterator($inputFolder, RecursiveDirectoryIterator::SKIP_DOTS);

        $current_folder = $inputFolder;

        // Execution Time - Start
        $executionTimeStart = microtime(true);

        /* Statistics values */
        $logErrors = 0;

        $this->wsAddStatistic("Start of import", date("l jS F \@ g:i:s a", $executionTimeStart));
        $this->sendMail(
            "Import started on machine " . gethostname(),
            "<b>Start of import:</b>&nbsp;" . date("l jS F \@ g:i:s a", $executionTimeStart) . "<BR>" .
            "<b>Folder of import:</b>&nbsp;" . $inputFolder
        );

        // After analyzing 5000 items send statistics email

        $tmbprocessor = new TMBProcessor($this->syncOmeka, false);
        $tmbprocessor->setTimeTMBProcessorStarted($executionTimeStart);

        foreach (new RecursiveIteratorIterator($di, RecursiveIteratorIterator::SELF_FIRST) as $filename => $file) {

            // echo "Checking " . $filename . "...\n";

            /*
            if ($file->isDir()) {

                if (strpos($filename , '/..') !== false) {
                    $current_folder = rtrim($filename, '/..');
                } else {
                    $current_folder = $filename;
                }

            } else {
            */

                /*
                $info_file_xls_old = basename($current_folder) . '_' . INFO_FILE . '.xls';
                $info_file_xls_new = basename($current_folder) . '_' . INFO_FILE . '.xlsx';
                */
                $info_file_xls_old = basename(dirname($file->getPathName())) . '_' . INFO_FILE . '.xls';
                $info_file_xls_new = basename(dirname($file->getPathName())) . '_' . INFO_FILE . '.xlsx';

                /*
                echo "info_file_xls_new file: " . $info_file_xls_new . "\n";
                echo "info_file_xls_new file alternative without current_folder: " . basename(dirname($file->getPathName())) . '_' . INFO_FILE . '.xlsx' . "\n";
                echo "file->getFilename(): " . $file->getFilename() . "\n";
                */

                if (($file->getFilename() == $info_file_xls_old) || ($file->getFilename() == $info_file_xls_new)) {

                    $current_folder = dirname($file->getPathName());

                    $collectionToImport = true;
                    /*
                     * Check if not tif files are present on folder do not elaborate file _info and not create collection
                     * */
                    $files = glob($current_folder . '/*.tif');
                    if (( $files === false ) || (count($files) <= 0)) {
                        $collectionToImport = false;

                        $this->wsLogMessage('<font color="#006400">' . "File with info " . $file->getFilename() . " founded but not tif files are present on folder!" . '</font>');
                        $record = new Log(null);
                        $record->operation_uuid = $operation_uuid;
                        $record->operation = 'Import';
                        $record->description = "File with info " . $file->getFilename() . " founded but not tif files are present on folder!";

                    } else {

                        $this->wsLogMessage('<font color="#006400">' . "File with info " . $file->getFilename() . " founded!" . '</font>');
                        $record = new Log(null);
                        $record->operation_uuid = $operation_uuid;
                        $record->operation = 'Import';
                        $record->description = "File with info " . $file->getFilename() . " founded!";
                    }

                    $resultInfo = callApi_createLog($record);
                    if (!strpos($resultInfo, 'cURL Error')) {
                    } else {
                        $this->wsLogMessage($resultInfo);
                    }

                    if ($collectionToImport) {
                        $outputFolder = $current_folder . '_output';

                        // Retrieving trailing name component of path
                        $signatureFolder = basename($current_folder);

                        // Building input paths
                        $inputMetaDataInfoFilePath =
                            $current_folder . '/' . $signatureFolder . '_' . INFO_FILE;
                        $inputMetaDataTCFilePath =
                            $current_folder . '/' . $signatureFolder . '_' . TC_FILE;

                        $inputMetaDataInfoFilePath_new =
                            $current_folder . '/' . $signatureFolder . '_' . INFO_FILE . '.xlsx';
                        $inputMetaDataTCFilePath_new =
                            $current_folder . '/' . $signatureFolder . '_' . TC_FILE . '.xlsx';

                        $inputMetaDataInfoFilePath_old =
                            $current_folder . '/' . $signatureFolder . '_' . INFO_FILE . '.xls';
                        $inputMetaDataTCFilePath_old =
                            $current_folder . '/' . $signatureFolder . '_' . TC_FILE . '.xls';

                        $inputProcessedFilesPath =
                            $current_folder . '/' . $signatureFolder . '_' . DONE_FILE;
                        $inputOmekaInfoPath =
                            $current_folder . '/' . $signatureFolder . '_' . OMEKA_INFO_FILE;

                        // Check if folder $current_folder has been already processed
                        if (!file_exists($inputProcessedFilesPath) || $this->forceProcedure) {

                            // Checking for missing files
                            $proceed = (file_exists($inputMetaDataInfoFilePath_new) && file_exists($inputMetaDataTCFilePath_new));
                            if (!$proceed) {
                                $proceed = (file_exists($inputMetaDataInfoFilePath_old) && file_exists($inputMetaDataTCFilePath_old));
                            }

                            if (!$proceed) {

                                $error_description = "Either " . $signatureFolder . "_" . INFO_FILE . " (.xlsx or .xls) or " . $signatureFolder . "_" . TC_FILE . " (.xlsx or .xls) is missing in " . $inputFolder . "!";
                                echo "\n!ERROR! - Missing files\n";
                                echo $error_description . "\n\n";

                                $this->wsLogMessage('<font color="#8b0000">' . $error_description . '</font>');

                                $logErrors++;
                                $this->wsUpdateStatistics($operation_uuid, "Errors found", $logErrors);

                                $record = new Log(null);
                                $record->operation_uuid = $operation_uuid;
                                $record->operation = 'Import';
                                $record->description = $error_description;

                                $resultInfo = callApi_createLog($record);
                                if (!strpos($resultInfo, 'cURL Error')) {
                                } else {
                                    $this->wsLogMessage($resultInfo);
                                }

                                // Do not exit if error is found but proceed with next folder!
                                // exit(EXIT_ERROR);

                            }

                            // Building output paths
                            $outputMetadataInfoFilePath =
                                $outputFolder . '/' . $signatureFolder . '_info.json';

                            // Deleting old info.json file
                            if (file_exists($outputMetadataInfoFilePath) && !$this->dryMode) {
                                unlink($outputMetadataInfoFilePath);
                            }

                            // Removing old output Folder from system if existing
                            if (file_exists($outputFolder) && !$this->dryMode) {
                                system('rm -rf ' . escapeshellarg($outputFolder));
                            }

                            // Building new output Folder
                            if (!$this->dryMode) {
                                mkdir($outputFolder, 0777, true);
                            }

                            // ==================================================
                            // ==================================================
                            // ==================================================

                            $this->wsLogMessage("Processing Info MetaData ...");

                            $partialExecutionTimeStart = microtime(true);

                            $newCollection = $tmbprocessor->infoProcessor(
                                $this,
                                $operation_uuid,
                                $inputMetaDataInfoFilePath,
                                $outputMetadataInfoFilePath,
                                $inputOmekaInfoPath,
                                $this->dryMode,
                                $this->createPublicItemsAndCollections
                            );

                            if ($newCollection !== null && isset($newCollection->id)) {
                                $omekaInfoFilePointer = fopen($inputOmekaInfoPath, 'w');

                                // echo "Collection to save: " . print_r($newCollection, true);

                                $dataObject = new stdClass();
                                $collectionObject = new stdClass();
                                $collectionObject->id = $newCollection->id;
                                $collectionObject->title = $newCollection->title;
                                $collectionObject->url = $newCollection->url;
                                $collectionObject->added = $newCollection->added;
                                $collectionObject->modified = $newCollection->modified;
                                $dataObject->collection = $collectionObject;

                                fwrite($omekaInfoFilePointer, json_encode($dataObject, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
                                fclose($omekaInfoFilePointer);
                            }

                            $partialExecutionTimeEnd = microtime(true);

                            $executionTime = ($partialExecutionTimeEnd - $partialExecutionTimeStart) / 60;

                            // Building output file path for saving time consumption
                            $outputTimesFilePath = $inputFolder . "/times.txt";
                            // Opening in write mode output file pointer
                            $timesFilePointer = fopen($outputTimesFilePath, 'w');
                            fwrite($timesFilePointer, ">> - Time machine box - Batch import execution times <<\n\n");
                            fwrite($timesFilePointer, "Processing info file execution time - | " . $executionTime . " | - Minutes\n");

                            // Closing previously opened file pointer
                            fclose($timesFilePointer);

                            $this->wsLogMessage("Processing MetaData and relative images ...");
                            $this->wsLogMessage("newCollection->title: " . $newCollection->title);
                            $this->wsLogMessage("newCollection->exifData: " . (isset($newCollection->exifData) ? $newCollection->exifData : 'Not present'));

                            $tmbprocessor->tcProcessor(
                                $this,
                                $operation_uuid,
                                $inputFolder,
                                $current_folder,
                                $outputFolder,
                                $inputMetaDataTCFilePath,
                                ($newCollection !== null && isset($newCollection->title)) ? $newCollection->title : '',
                                ($newCollection !== null && isset($newCollection->id)) ? $newCollection->id : '',
                                ($newCollection !== null && isset($newCollection->exifData)) ? $newCollection->exifData : '',
                                $this->dryMode,
                                $this->createOriNameFromID,
                                $this->itemTitleField,
                                $this->createPublicItemsAndCollections
                            );

                            if (!$this->dryMode) {
                                $doneFilePointer = fopen($inputProcessedFilesPath, 'w');
                                fwrite($doneFilePointer, $current_folder . " processed with success on " . time());
                                fclose($doneFilePointer);
                            }

                        } else {

                            $this->wsLogMessage('<font color="#ff8c00">Folder ' . basename($current_folder) . ' already processed!</font>');
                            $record = new Log(null);
                            $record->operation_uuid = $operation_uuid;
                            $record->operation = 'Import';
                            $record->description = 'Folder ' . basename($current_folder) . ' already processed!';
                            $resultInfo = callApi_createLog($record);
                            if (!strpos($resultInfo, 'cURL Error')) {
                                /*$resultInfo = json_decode($resultInfo);
                                $this->getServer()->wsSend($clientID, $resultInfo->message);*/
                            } else {
                                $this->wsLogMessage($resultInfo);
                            }


                        }
                    }

                }
            //}
        }

        // Execution Time - End
        $executionTimeEnd = microtime(true);
        $executionTimeTotal = round($executionTimeEnd, 3) - round($executionTimeStart, 3);

        $this->wsAddStatistic("End of import", date("l jS F \@ g:i:s a", $executionTimeEnd));
        $this->sendMail(
            "Import ended on machine " . gethostname() . " at " . $this->formatSecondsToReadableString($executionTimeTotal),
            "<b>End of import:</b>&nbsp;" . date("l jS F \@ g:i:s a", $executionTimeEnd) . "<br>" .
            "<b>Elaborated collections:</b> " . $tmbprocessor->getElaboratedCollections() . "<br>" .
            "<b>Elaborated items:</b> " . $tmbprocessor->getElaboratedItems()
        );

        return $operation_uuid;
    }

    private function convertAndUploadFilze() {

        $inputFolder = rtrim($this->inputFolderPath, '/');

        $operation_uuid = Uuid::uuid4()->toString();

        // Execution Time - Start
        $executionTimeStart = microtime(true);

        /* Statistics values */
        $logErrors = 0;

        $this->wsAddStatistic("Start of import", date("l jS F \@ g:i:s a", $executionTimeStart));
        $this->sendMail(
            "Import started on machine " . gethostname(),
            "<b>Start of import:</b>&nbsp;" . date("l jS F \@ g:i:s a", $executionTimeStart) . "<BR>" .
            "<b>Folder of import:</b>&nbsp;" . $inputFolder
        );

        $tmbprocessor = new TMBProcessor($this->syncOmeka, false);
        $tmbprocessor->setTimeTMBProcessorStarted($executionTimeStart);

        /* Create file for updating collection_tree table */
        $ct_update_filename = $inputFolder . '/' . 'collection_tree_update.sql';
        $this->ct_update_filenamePointer = fopen($ct_update_filename, 'w');

        $this->scanForFilzeImport($inputFolder, $tmbprocessor, $operation_uuid);

        // Close also file for uptdating collection_treee
        fclose($this->ct_update_filenamePointer);

        // Execution Time - End
        $executionTimeEnd = microtime(true);
        $executionTimeTotal = round($executionTimeEnd, 3) - round($executionTimeStart, 3);

        $this->wsAddStatistic("End of import", date("l jS F \@ g:i:s a", $executionTimeEnd));
        $this->sendMail(
            "Import ended on machine " . gethostname() . " at " . $this->formatSecondsToReadableString($executionTimeTotal),
            "<b>End of import:</b>&nbsp;" . date("l jS F \@ g:i:s a", $executionTimeEnd) . "<br>" .
            "<b>Elaborated collections:</b> " . $tmbprocessor->getElaboratedCollections() . "<br>" .
            "<b>Elaborated items:</b> " . $tmbprocessor->getElaboratedItems()
        );

        return $operation_uuid;

    }

    public function ciniArchivesNormalization() {

        $debug = false;


        $inputFolder = rtrim($this->inputFolderPath, '/');
        $onlyCheckNormalization = $this->onlyCheckNormalization;
        $this->wsLogMessage("inputFolder: " . $inputFolder);

        $current_folder = $inputFolder;

        // I have to cycle all xml files on $inputFolder and create for any folder a _info file and a _tc file
        $di = new RecursiveDirectoryIterator($inputFolder, RecursiveDirectoryIterator::SKIP_DOTS);
        foreach (new RecursiveIteratorIterator($di, RecursiveIteratorIterator::SELF_FIRST) as $filename => $file) {

            if ($file->isDir()) {

                if (strpos($filename , '/..') !== false) {
                    $current_folder = rtrim($filename, '/..');
                } else {
                    $current_folder = $filename;
                }

            } else {

                if ((!$onlyCheckNormalization) && ($debug)) {
                    $this->wsLogMessage("Processing file (only file name): " . $file->getFilename());
                    $this->wsLogMessage("Processing file (full path): " . $filename);
                }

                $fileExtension = pathinfo($file->getFilename(), PATHINFO_EXTENSION);

                // Checking if the image file is supported for conversion
                if (in_array($fileExtension, ['xml', 'XML']) || (strpos($filename, '_Xml_') !== false)) {

                    $xmlDoc = new DOMDocument();
                    if ($debug) {
                        $this->wsLogMessage("** Filename of XML to load: " . $filename . " **");
                    }
                    $xmlDoc->load($filename);

                    $mag_gen_tokens = ["stprog", "collection", "agency", "access_rights", "completeness", "img_group"];
                    $mag_img_group_tokens = ["image_metrics", "format", "scanning"];
                    $mag_bib_tokens = ["identifier", "title", "creator", "publisher", "date", "type", "source", "language", "holdings"];
                    $mag_img_tokens = ["sequence_number", "nomenclature", "usage", "md5", "filesize", "image_dimensions", "file"];

                    $digits = $xmlDoc->getElementsByTagName( "metadigit" );
                    foreach( $digits as $digitRow ) {
                        $gens = $digitRow->getElementsByTagName("gen");
                        $genArray = array();
                        foreach( $gens as $genRow ) {
                            $genObj = new stdClass();

                            for ($idx = 0; $idx < count($mag_gen_tokens); $idx++) {

                                $tag = $genRow->getElementsByTagName($mag_gen_tokens[$idx]);

                                if ($mag_gen_tokens[$idx] === 'img_group') {

                                    foreach( $tag as $tagRow ) {
                                        $ID = $tagRow->getAttribute("ID");
                                        //error_log("img_group ID Attribute: " . $ID);
                                        if ($ID === "CINI-01") {
                                            $genObj->exifData = '';

                                            for ($idy = 0; $idy < count($mag_img_group_tokens); $idy++) {
                                                $img_group_tag = $tagRow->getElementsByTagName($mag_img_group_tokens[$idy]);
                                                //error_log("***");
                                                //error_log(print_r(iterator_to_array($img_group_tag), true));
                                                switch ($mag_img_group_tokens[$idy]) {
                                                    case "image_metrics":
                                                        foreach ($img_group_tag as $img_group_tagRow) {
                                                            if (trim($genObj->exifData) !== '') {
                                                                $genObj->exifData .= ";";
                                                            }
                                                            $genObj->exifData .= "samplingfrequencyunit:" . $img_group_tagRow->getElementsByTagName("samplingfrequencyunit")->item(0)->nodeValue . ";";
                                                            $genObj->exifData .= "samplingfrequencyplane:" . $img_group_tagRow->getElementsByTagName("samplingfrequencyplane")->item(0)->nodeValue . ";";
                                                            $genObj->exifData .= "xsamplingfrequency:" . $img_group_tagRow->getElementsByTagName("xsamplingfrequency")->item(0)->nodeValue . ";";
                                                            $genObj->exifData .= "ysamplingfrequency:" . $img_group_tagRow->getElementsByTagName("ysamplingfrequency")->item(0)->nodeValue . ";";
                                                            $genObj->exifData .= "photometricinterpretation:" . $img_group_tagRow->getElementsByTagName("photometricinterpretation")->item(0)->nodeValue . ";";
                                                            $genObj->exifData .= "bitpersample:" . $img_group_tagRow->getElementsByTagName("bitpersample")->item(0)->nodeValue;
                                                        }
                                                        break;

                                                    case "format":
                                                        foreach ($img_group_tag as $img_group_tagRow) {
                                                            if (trim($genObj->exifData) !== '') {
                                                                $genObj->exifData .= ";";
                                                            }
                                                            $genObj->exifData .= "name:" . $img_group_tagRow->getElementsByTagName("name")->item(0)->nodeValue . ";";
                                                            $genObj->exifData .= "mime:" . $img_group_tagRow->getElementsByTagName("mime")->item(0)->nodeValue . ";";
                                                            $genObj->exifData .= "compression:" . $img_group_tagRow->getElementsByTagName("compression")->item(0)->nodeValue;

                                                        }
                                                        break;

                                                    case "scanning":
                                                        $scanning_system_tag = $tagRow->getElementsByTagName("scanningsystem");
                                                        foreach ($scanning_system_tag as $scanning_system_tagRow) {
                                                            if (trim($genObj->exifData) !== '') {
                                                                $genObj->exifData .= ";";
                                                            }
                                                            $genObj->exifData .= "scanner_manufacturer:" . $scanning_system_tagRow->getElementsByTagName("scanner_manufacturer")->item(0)->nodeValue . ";";
                                                            $genObj->exifData .= "scanner_model:" . $scanning_system_tagRow->getElementsByTagName("scanner_model")->item(0)->nodeValue . ";";
                                                            $genObj->exifData .= "capture_software:" . $scanning_system_tagRow->getElementsByTagName("capture_software")->item(0)->nodeValue;

                                                        }
                                                        break;

                                                    default:
                                                        $genObj->{$mag_img_group_tokens[$idy]} = $img_group_tag->item(0)->nodeValue;
                                                }
                                                //error_log("genObj->exifData: " . $genObj->exifData);
                                            }
                                        }
                                    }

                                } else {
                                    $genObj->{$mag_gen_tokens[$idx]} = $tag->item(0)->nodeValue;
                                }

                            }

                            $genArray[] = $genObj;
                        }

                        //error_log("gen begin");
                        foreach ($genArray as $genItem) {
                            // error_log(print_r($genItem, true));
                        }
                        //error_log("gen end");

                        $bibs = $digitRow->getElementsByTagName("bib");
                        $bibArray = array();
                        //error_log("bib begin");
                        foreach( $bibs as $bibRow ) {
                            $bibObj = new stdClass();

                            for ($idx = 0; $idx < count($mag_bib_tokens); $idx++) {
                                $tag = $bibRow->getElementsByTagName($mag_bib_tokens[$idx]);

                                if ($mag_bib_tokens[$idx] == "holdings") {
                                    //error_log(print_r(iterator_to_array($tag), true));
                                    $bibObj->{$mag_bib_tokens[$idx] . "_" . "library"} = $tag->item(0)->getElementsByTagName('library')->item(0)->nodeValue;
                                } else {
                                    if ($tag->item(0) !== null) {
                                        $bibObj->{$mag_bib_tokens[$idx]} = $tag->item(0)->nodeValue;
                                    }
                                }

                            }

                            $bibArray[] = $bibObj;
                        }


                        foreach ($bibArray as $bibItem) {
                            // error_log(print_r($bibItem, true));
                        }

                        //error_log("bib end");

                        $tiff_path = $current_folder . "/../TIFF/TIFF-" . substr($bibItem->identifier, 0, 6) . "/" . trim($bibItem->identifier) . "/";

                        // Create folder for collection
                        if (!file_exists($tiff_path)) {
                            if (!$onlyCheckNormalization) {
                                mkdir($tiff_path, 0777, true);
                            } else {
                                $this->wsLogMessage("** I have to create folder with name: " . $tiff_path . " **");
                            }
                        }

                        // Building input paths

                        $inputMetaDataInfoFilePath =
                            $tiff_path . trim($bibItem->identifier) . '_' . INFO_FILE . '.xlsx';

                        $inputMetaDataTCFilePath =
                            $tiff_path . trim($bibItem->identifier) . '_' . TC_FILE . '.xlsx';

                        /* inputMetaDataInfoFilePath creation begin */
                        if (!$onlyCheckNormalization) {
                            $objPHPExcel = new PHPExcel();
                            $cacheMehod = PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
                            $res = PHPExcel_Settings::setCacheStorageMethod($cacheMehod);
                            PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);

                            $objPHPExcel->getDefaultStyle()->getFont()->setName('Abadi MT Condensed Light');
                            $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);

                            $objPHPExcel->getProperties()->setCreator("Mind@ware Srl");
                            $objPHPExcel->getProperties()->setLastModifiedBy("Mind@ware Srl");
                            $objPHPExcel->getProperties()->setTitle("Office 2007 info metadata");
                            $objPHPExcel->getProperties()->setSubject("Office 2007 info metadata");
                            $objPHPExcel->getProperties()->setDescription("Office 2007 info metadata");

                            $sheet = $objPHPExcel->getActiveSheet()->setTitle("Main");

                            $list = array();
                            $objList = new stdClass();
                            $objList->maintenanceagency = $genItem->agency;
                            $objList->recordid = $bibItem->identifier;
                            $objList->series = $bibItem->holdings_library;
                            $objList->level = '';
                            $objList->signature = '';
                            $objList->code = '';
                            $objList->title = $bibItem->title;
                            $objList->description = '';
                            $objList->type = $bibItem->type;
                            $objList->physdesc = "";
                            $objList->extent = "";
                            $objList->legatura = "";

                            if (isset($bibItem->creator)) {
                                $objList->creator = $bibItem->creator;
                            } else {
                                $objList->creator = '';
                            }

                            $objList->otherfindaid = "";
                            $objList->date_sec_start = "";
                            $objList->date_sec_specify_start = "";

                            if (isset($bibItem->date)) {
                                $objList->date_year_start = $bibItem->date;
                            } else {
                                $objList->date_year_start = '';
                            }

                            $objList->date_month_start = "";
                            $objList->date_day_start = "";
                            $objList->date_start_certainty = "";
                            $objList->date_sec_end = "";
                            $objList->date_sec_specify_end = "";
                            $objList->date_year_end = "";
                            $objList->date_month_end = "";

                            $objList->date_day_end = "";
                            $objList->date_end_certainty = "";
                            $objList->date_notes = "";
                            $objList->name = "";
                            $objList->altformavail = "";
                            $objList->operator = "";

                            if (isset($genItem->exifData)) {
                                $objList->exifData = $genItem->exifData;
                            } else {
                                $objList->exifData = '';
                            }

                            $list [] = $objList;
                            $dbfields = [
                                'maintenanceagency', 'recordid', 'series', 'level', 'signature', 'code', 'title', 'description', 'type',
                                'physdesc', 'extent', 'legatura', 'creator', 'otherfindaid', 'date_sec_start', 'date_sec_specify_start', 'date_year_start',
                                'date_month_start', 'date_day_start', 'date_start_certainty', 'date_sec_end', 'date_sec_specify_end', 'date_year_end', 'date_month_end',
                                'date_day_end', 'date_end_certainty', 'date_notes', 'name', 'altformavail', 'operator', 'exifData'
                            ];
                            $this->fillHeaderAndValues($sheet, $list/*$list*/, INFO_FIELDS_ARRAY/*$labels*/, $dbfields/*$dbfields*/);

                            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                            if ($debug) {
                                $this->wsLogMessage("** collection filename of save: " . $inputMetaDataInfoFilePath . "**");
                            }
                            $objWriter->save($inputMetaDataInfoFilePath);

                            $objPHPExcel->disconnectWorksheets();
                            unset($objPHPExcel);
                        }
                        /* inputMetaDataInfoFilePath creation end */

                        // Images
                        $imgs = $digitRow->getElementsByTagName("img");
                        $imgArray = array();
                        foreach( $imgs as $imgRow ) {
                            $imgObj = new stdClass();

                            for ($idx = 0; $idx < count($mag_img_tokens); $idx++) {
                                $tag = $imgRow->getElementsByTagName($mag_img_tokens[$idx]);

                                if ($tag->length > 1) {
                                    switch ($mag_img_tokens[$idx]) {
                                        case "image_dimensions":
                                            foreach( $tag as $tagRow ) {
                                                $imagelength = $tagRow->getElementsByTagName("imagelength");
                                                $imagewidth = $tagRow->getElementsByTagName("imagewidth");
                                            }
                                            $imgObj->{$mag_img_tokens[$idx].'_'."imagelength"} = $imagelength->item(0)->nodeValue;
                                            $imgObj->{$mag_img_tokens[$idx].'_'."imagewidth"} = $imagewidth->item(0)->nodeValue;
                                            break;
                                        case "file":
                                            foreach( $tag as $tagRow ) {
                                                $xLink = $tagRow->getAttribute("xlink:href");
                                                $queryOfxLink = parse_url ( $xLink, PHP_URL_QUERY);
                                                parse_str($queryOfxLink, $query_array);
                                                $imgObj->{$mag_img_tokens[$idx].'_'."id"} = $query_array['id']*1-1;
                                            }

                                            break;
                                        default:
                                            $imgObj->{$mag_img_tokens[$idx]} = $tag->item(0)->nodeValue;
                                    }
                                } else {
                                    $imgObj->{$mag_img_tokens[$idx]} = $tag->item(0)->nodeValue;
                                }
                            }

                            $imgArray[] = $imgObj;
                        }

                        /*
                        foreach ($imgArray as $imgItem) {
                            error_log(print_r($imgItem, true));
                        }
                        */

                        /* inputMetaDataTCFilePath creation begin */
                        $list = array();
                        foreach ($imgArray as $imgItem) {
                            $objList = new stdClass();
                            $objList->id = $imgItem->sequence_number;
                            $objList->notes = "";
                            $objList->originalFileName = $imgItem->file_id . '_' . $bibItem->identifier . '.' . $imgItem->sequence_number . ".tif";
                            $objList->filename = "";
                            $objList->fileMD5 = "";
                            $objList->cartulazione1 = $imgItem->nomenclature;

                            if (file_exists($tiff_path . $objList->originalFileName)) {
                                $objList->file_founded = "1";
                            } else {
                                $objList->file_founded = "0";
                            }
                            $list [] = $objList;
                        }

                        if (!$onlyCheckNormalization) {
                            $objPHPExcel = new PHPExcel();
                            $cacheMehod = PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
                            $res = PHPExcel_Settings::setCacheStorageMethod($cacheMehod);
                            PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);

                            $objPHPExcel->getDefaultStyle()->getFont()->setName('Abadi MT Condensed Light');
                            $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);

                            $objPHPExcel->getProperties()->setCreator("Mind@ware Srl");
                            $objPHPExcel->getProperties()->setLastModifiedBy("Mind@ware Srl");
                            $objPHPExcel->getProperties()->setTitle("Office 2007 tc metadata");
                            $objPHPExcel->getProperties()->setSubject("Office 2007 tc metadata");
                            $objPHPExcel->getProperties()->setDescription("Office 2007 tc metadata");

                            $sheet = $objPHPExcel->getActiveSheet()->setTitle("Main");

                            $dbfields = ['id', 'notes', 'originalFileName', 'filename', 'fileMD5', 'cartulazione1'/*, 'file_founded'*/];
                            $labels = TC_FIELDS_ARRAY;
                            // $labels [] = 'file_founded';
                            $this->fillHeaderAndValues($sheet, $list/*$list*/, $labels, $dbfields/*$dbfields*/);

                            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                            if ($debug) {
                                error_log("** items filename of save: " . $inputMetaDataTCFilePath . "**");
                                $this->wsLogMessage("** items filename of save: " . $inputMetaDataTCFilePath . "**");
                            }
                            $objWriter->save($inputMetaDataTCFilePath);

                            $objPHPExcel->disconnectWorksheets();
                            unset($objPHPExcel);
                        }

                        // Move file from old location to new location
                        foreach ($imgArray as $imgItem) {
                            $objList->originalFileName = $imgItem->file_id . '_' . $bibItem->identifier . '.' . $imgItem->sequence_number . ".tif";
                            $oldLocation = $current_folder . "/../TIFF/TIFF-" . substr($bibItem->identifier, 0, 6) . "/" . $objList->originalFileName;
                            if (!$onlyCheckNormalization) {
                                if (file_exists($oldLocation)) {

                                    $newLocation = $current_folder . "/../TIFF/TIFF-" . substr($bibItem->identifier, 0, 6) . "/" . trim($bibItem->identifier) . "/" . $objList->originalFileName;
                                    if (!file_exists($newLocation)) {
                                        $this->wsLogMessage("** Moving file from " . $oldLocation . " to " . $newLocation . " **");
                                        rename($oldLocation, $newLocation);
                                        $this->wsLogMessage("** File " . $newLocation . " created **");
                                    }

                                }
                            } else {
                                if (file_exists($oldLocation)) {
                                    $newLocation = $current_folder . "/../TIFF/TIFF-" . substr($bibItem->identifier, 0, 6) . "/" . trim($bibItem->identifier) . "/" . $objList->originalFileName;
                                    $this->wsLogMessage("** Filename on folder " . $oldLocation . " should be moved to folder " . $newLocation . " **");
                                }
                            }
                        }
                        /* inputMetaDataTCFilePath creation end */

                    }

                }

            }

        }

        $this->wsMessageDone();

    }

    private function fillHeaderAndValues($sheet, $list, $labelArray, $fieldArray) {

        $debug = false;

        foreach($labelArray as $key => $label) {
            $sheet->setCellValue($this->getCoordinates($key,1), $label);
        }
        $sheet->getStyle($this->getCoordinates(min(array_keys($labelArray)),1) . ":" . $this->getCoordinates(max(array_keys($labelArray)),1))->getFont()->setBold(true);

        $num_rows = $sheet->getHighestRow();
        $sheet->insertNewRowBefore($num_rows + 1, 1);
        $sheet->getStyle($this->getCoordinates(min(array_keys($labelArray)),2) . ":" . $this->getCoordinates(max(array_keys($labelArray)),2))->getFont()->setBold(false);

        if ($list !== null) {
            $rowIterator = $sheet->getRowIterator(2);

            foreach ($list as $element) {
                $currentRow = $rowIterator->current();

                /*
                if ($debug) {
                    echo "Processing element with recordid " . $element->recordid . "\n";
                }*/

                $cellIterator = $currentRow->getCellIterator();
                $cellIterator->setIterateOnlyExistingCells(false);
                foreach ($fieldArray as $field) {

                    /** @var PHPExcel_Cell $currentCell */
                    $currentCell = $cellIterator->current();

                    if ($debug) {
                        echo "\tField: " . $field . "";
                        echo "\tValue: " . $element->$field . "";
                        echo "\tCoordinates: " . $currentCell->getCoordinate() . "\n";
                    }

                    if (isset($element->$field) && $element->$field != NULL && $element->$field != '') {
                        $currentCell->setValue($element->$field);
                    }

                    $cellIterator->next();
                }

                $rowIterator->next();
            }

            /*
            for($column = min(array_keys($labelArray)) ; $column <= max(array_keys($labelArray)) ; $column++) {
                $sheet->getColumnDimensionByColumn($column)->setAutoSize(true);
            }

            $sheet->calculateColumnWidths();
            */

        }

    }

    private function getCoordinates($columnIndex,$rowIndex) {
        return PHPExcel_Cell::stringFromColumnIndex($columnIndex) . $rowIndex;
    }

}
