<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 26/10/17
 * Time: 17:29
 */

require_once ("OperationsManagement.php");

class OmekaInfoOperations extends OperationsManagement {

    public $isoDate = '';
    public $download = '';
    public $days = 0;
    public $importFolderPath = '';
    public $deleteRelatedItems = true;
    public $dryMode = false;

    public function getAddedCollections() {

        $omekaAPI = new OmekaAPIWrapper(false);
        $omekaAPI->setVerboseMode(true);
        $collections = $omekaAPI->getCollections($this->isoDate);

        $this->wsLogMessage("List of added collections from " . $this->isoDate);

        foreach ($collections as $collection) {
            $this->wsLogMessage("Collection with id: " . $collection->id);
        }

        if(isset($this->download) && $this->download !== "" && $this->download !== "none") {

            $now = new DateTime('NOW');
            $now = $now->format(DateTime::ATOM);
            $mainDownloadFolder = 'collections-download-' . $now . '/';
            if(file_exists($mainDownloadFolder)) {
                system('rm -rf ' . escapeshellarg($mainDownloadFolder));
            }
            foreach ($collections as $collection) {

                $files = $omekaAPI->collectionFilesDownload($collection->id, $this->download);
                if ($files !== null) {
                    foreach ($files as $file) {

                        $downloadFolder = $mainDownloadFolder . $collection->id . "/";

                        // Building new download Folder if not exist
                        if(!file_exists($downloadFolder)) {
                            mkdir($downloadFolder, 0777, true);
                        }

                        if ($file->type === 'manifest') {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                json_encode($file->data, JSON_UNESCAPED_SLASHES)
                            );
                        } else {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                base64_decode($file->data)
                            );
                        }

                        $this->wsLogMessage("File " . $downloadFolder . $file->filename . " created");

                        /*
                         * If $options['download'] === 'all' or 'files' then I have to parse manifest file and download item images of items belong to collection
                         * */
                        if (($this->download === 'all') || ($this->download === 'files')) {

                            $this->wsLogMessage("Parsing collection manifest file...");
                            $this->wsLogMessage("Sequences number: " . count($file->data->sequences));

                            if (count($file->data->sequences) > 0) {
                                $this->wsLogMessage("Canvases number: " . count($file->data->sequences[0]->canvases));
                            }

                            if ((count($file->data->sequences) > 0) && count($file->data->sequences[0]->canvases) > 0) {
                                foreach ($file->data->sequences[0]->canvases as $canvas) {
                                    $canvas_id_array = explode("/", $canvas->{'@id'});
                                    $element_id = $canvas_id_array[count($canvas_id_array) - 2];
                                    // echo "Element to retrieve: " . $element_id . "\n";
                                    $item_files = $omekaAPI->itemFilesDownload($element_id, $this->download);
                                    if ($item_files !== null) {
                                        foreach ($item_files as $item_file) {


                                            if ($item_file->type === 'manifest') {
                                                file_put_contents(
                                                    $downloadFolder . $item_file->filename,
                                                    json_encode($item_file->data, JSON_UNESCAPED_SLASHES)
                                                );
                                            } else {
                                                file_put_contents(
                                                    $downloadFolder . $item_file->filename,
                                                    base64_decode($item_file->data)
                                                );
                                            }

                                            $this->wsLogMessage("File " . $downloadFolder . $item_file->filename . " created");
                                        }
                                    }
                                }
                            }

                        }

                    }
                }

            }
        }

        $this->wsMessageDone();

    }

    public function getModifiedCollections() {

        $omekaAPI = new OmekaAPIWrapper(false);
        $omekaAPI->setVerboseMode(true);
        $collections = $omekaAPI->getCollections(null, $this->isoDate);

        $this->wsLogMessage("List of modified collections from " . $this->isoDate);
        foreach ($collections as $collection) {
            $this->wsLogMessage("Collection with id: " . $collection->id);
        }

        if(isset($this->download) && $this->download !== "" && $this->download !== "none") {

            $now = new DateTime('NOW');
            $now = $now->format(DateTime::ATOM);
            $mainDownloadFolder = 'collections-download-' . $now . '/';
            if(file_exists($mainDownloadFolder)) {
                system('rm -rf ' . escapeshellarg($mainDownloadFolder));
            }
            foreach ($collections as $collection) {
                $files = $omekaAPI->collectionFilesDownload($collection->id, $this->download);
                if ($files !== null) {
                    foreach ($files as $file) {
                        $downloadFolder = $mainDownloadFolder . $collection->id . "/";

                        // Building new download Folder if not exist
                        if(!file_exists($downloadFolder)) {
                            mkdir($downloadFolder, 0777, true);
                        }

                        if ($file->type === 'manifest') {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                json_encode($file->data, JSON_UNESCAPED_SLASHES)
                            );
                        } else {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                base64_decode($file->data)
                            );
                        }

                        $this->wsLogMessage("File " . $mainDownloadFolder . $file->filename . " created");

                        /*
                         * If $options['download'] === 'all' or 'files' then I have to parse manifest file and download item images of items belong to collection
                         * */
                        if (($this->download === 'all') || ($this->download === 'files')) {

                            $this->wsLogMessage("Parsing collection manifest file...");
                            $this->wsLogMessage("Sequences number: " . count($file->data->sequences));

                            if (count($file->data->sequences) > 0) {
                                $this->wsLogMessage("Canvases number: " . count($file->data->sequences[0]->canvases));
                            }

                            if ((count($file->data->sequences) > 0) && count($file->data->sequences[0]->canvases) > 0) {
                                foreach ($file->data->sequences[0]->canvases as $canvas) {
                                    $canvas_id_array = explode("/", $canvas->{'@id'});
                                    $element_id = $canvas_id_array[count($canvas_id_array) - 2];
                                    // echo "Element to retrieve: " . $element_id . "\n";
                                    $item_files = $omekaAPI->itemFilesDownload($element_id, $this->download);
                                    if ($item_files !== null) {
                                        foreach ($item_files as $item_file) {


                                            if ($item_file->type === 'manifest') {
                                                file_put_contents(
                                                    $downloadFolder . $item_file->filename,
                                                    json_encode($item_file->data, JSON_UNESCAPED_SLASHES)
                                                );
                                            } else {
                                                file_put_contents(
                                                    $downloadFolder . $item_file->filename,
                                                    base64_decode($item_file->data)
                                                );
                                            }

                                            $this->wsLogMessage("File " . $downloadFolder . $item_file->filename . " created");
                                        }
                                    }
                                }
                            }

                        }
                    }
                }
            }
        }

        $this->wsMessageDone();

    }

    public function getAddedItems() {

        $omekaAPI = new OmekaAPIWrapper(false);
        $omekaAPI->setVerboseMode(true);
        $items = $omekaAPI->getItems($this->isoDate);

        $this->wsLogMessage("List of added items from " . $this->isoDate);
        foreach ($items as $item) {
            $this->wsLogMessage("Item with id: " . $item->id);
        }

        if(isset($this->download) && $this->download !== "" && $this->download !== "none") {

            $now = new DateTime('NOW');
            $now = $now->format(DateTime::ATOM);
            $mainDownloadFolder = 'items-download-' . $now . '/';
            if (file_exists($mainDownloadFolder)) {
                system('rm -rf ' . escapeshellarg($mainDownloadFolder));
            }
            foreach ($items as $item) {
                try {
                    $files = $omekaAPI->itemFilesDownload($item->id, $this->download);
                    if ($files !== null) {
                        foreach ($files as $file) {
                            $downloadFolder = $mainDownloadFolder . $item->id . "/";

                            // Building new download Folder if not exist
                            if (!file_exists($downloadFolder)) {
                                mkdir($downloadFolder, 0777, true);
                            }

                            if ($file->type === 'manifest') {
                                file_put_contents(
                                    $downloadFolder . $file->filename,
                                    json_encode($file->data, JSON_UNESCAPED_SLASHES)
                                );
                            } else {
                                file_put_contents(
                                    $downloadFolder . $file->filename,
                                    base64_decode($file->data)
                                );
                            }
                            $this->wsLogMessage("File " . $mainDownloadFolder . $file->filename . " created");
                        }
                    }
                } catch (Exception $e) {
                    $this->wsLogMessage("Error on getAddedItems function: " . $e->getMessage());
                }
            }
        }

        $this->wsMessageDone();
    }

    public function getModifiedItems() {

        $omekaAPI = new OmekaAPIWrapper(false);
        $omekaAPI->setVerboseMode(true);
        $items = $omekaAPI->getItems(null, $this->isoDate);

        $this->wsLogMessage("List of modified items from " . $this->isoDate);
        foreach ($items as $item) {
            $this->wsLogMessage("Item with id: " . $item->id);
        }

        if(isset($this->download) && $this->download !== "" && $this->download !== "none") {

            $now = new DateTime('NOW');
            $now = $now->format(DateTime::ATOM);
            $mainDownloadFolder = 'items-download-' . $now . '/';
            if(file_exists($mainDownloadFolder)) {
                system('rm -rf ' . escapeshellarg($mainDownloadFolder));
            }
            foreach ($items as $item) {
                $files = $omekaAPI->itemFilesDownload($item->id, $this->download);
                if ($files !== null) {
                    foreach ($files as $file) {
                        $downloadFolder = $mainDownloadFolder . $item->id . "/";

                        // Building new download Folder if not exist
                        if(!file_exists($downloadFolder)) {
                            mkdir($downloadFolder, 0777, true);
                        }

                        if ($file->type === 'manifest') {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                json_encode($file->data, JSON_UNESCAPED_SLASHES)
                            );
                        } else {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                base64_decode($file->data)
                            );
                        }
                        $this->wsLogMessage("File " . $mainDownloadFolder . $file->filename . " created");
                    }
                }
            }
        }

        $this->wsMessageDone();

    }

    public function getLastDaysAddedItems() {

        $omekaAPI = new OmekaAPIWrapper();
        $omekaAPI->setVerboseMode(true);
        $items = $omekaAPI->getLastDaysAddedItems($this->days);

        $this->wsLogMessage("List of added items of last " . $this->days . " days");
        foreach ($items as $item) {
            $this->wsLogMessage("Item with id: " . $item->id);
        }

        if(isset($this->download)) {

            $now = new DateTime('NOW');
            $now = $now->format(DateTime::ATOM);
            $mainDownloadFolder = 'items-download-' . $now . '/';
            if(file_exists($mainDownloadFolder)) {
                system('rm -rf ' . escapeshellarg($mainDownloadFolder));
            }
            foreach ($items as $item) {
                $files = $omekaAPI->itemFilesDownload($item->id, $this->download);
                if ($files !== null) {
                    foreach ($files as $file) {
                        $downloadFolder = $mainDownloadFolder . $item->id . "/";

                        // Building new download Folder if not exist
                        if(!file_exists($downloadFolder)) {
                            mkdir($downloadFolder, 0777, true);
                        }

                        if ($file->type === 'manifest') {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                json_encode($file->data, JSON_UNESCAPED_SLASHES)
                            );
                        } else {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                base64_decode($file->data)
                            );
                        }
                        $this->wsLogMessage("File " . $mainDownloadFolder . $file->filename . " created");
                    }
                }
            }
        }

        $this->wsMessageDone();

    }

    public function getLastDaysModifiedItems() {

        $omekaAPI = new OmekaAPIWrapper(false);
        $omekaAPI->setVerboseMode(true);
        $items = $omekaAPI->getLastDaysModifiedItems($this->days);

        $this->wsLogMessage("List of modified items of last " . $this->days . " days");
        foreach ($items as $item) {
            $this->wsLogMessage("Item with id: " . $item->id);
        }

        if(isset($this->download)) {

            $now = new DateTime('NOW');
            $now = $now->format(DateTime::ATOM);
            $mainDownloadFolder = 'items-download-' . $now . '/';
            if(file_exists($mainDownloadFolder)) {
                system('rm -rf ' . escapeshellarg($mainDownloadFolder));
            }
            foreach ($items as $item) {
                $files = $omekaAPI->itemFilesDownload($item->id, $this->download);
                if ($files !== null) {
                    foreach ($files as $file) {
                        $downloadFolder = $mainDownloadFolder . $item->id . "/";

                        // Building new download Folder if not exist
                        if(!file_exists($downloadFolder)) {
                            mkdir($downloadFolder, 0777, true);
                        }

                        if ($file->type === 'manifest') {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                json_encode($file->data, JSON_UNESCAPED_SLASHES)
                            );
                        } else {
                            file_put_contents(
                                $downloadFolder . $file->filename,
                                base64_decode($file->data)
                            );
                        }

                        $this->wsLogMessage("File " . $mainDownloadFolder . $file->filename . " created");
                    }
                }
            }
        }

        $this->wsMessageDone();

    }

    public function deleteCollectionsFromFolder() {

        $omekaAPI = new OmekaAPIWrapper(false);
        $omekaAPI->setVerboseMode(true);

        $deleteRelatedItems = (isset($this->deleteRelatedItems)) ? $this->deleteRelatedItems : true;

        if (isset($this->importFolderPath) && (trim($this->importFolderPath) !== '')) {
            $this->wsLogMessage("I have to analyze folder " . $this->importFolderPath . " to get all collections that have to be deleted...");
            if ($this->deleteRelatedItems) {
                $this->wsLogMessage("I have to delete also related items...");
            }

            $inputFolder = rtrim($this->importFolderPath, '/');

            $di = new RecursiveDirectoryIterator($inputFolder, RecursiveDirectoryIterator::SKIP_DOTS);

            $current_folder = $inputFolder;

            // Execution Time - Start
            $executionTimeStart = microtime(true);

            $this->wsAddStatistic("Start of deleting collections from folder " . $inputFolder, date("l jS F \@ g:i:s a", $executionTimeStart));

            foreach (new RecursiveIteratorIterator($di, RecursiveIteratorIterator::SELF_FIRST) as $filename => $file) {

                if ($file->isDir()) {

                    if (strpos($filename , '/..') !== false) {
                        $current_folder = rtrim($filename, '/..');
                    } else {
                        $current_folder = $filename;
                    }

                } else {

                    $info_file_xls_old = basename($current_folder) . '_' . INFO_FILE . '.xls';
                    $info_file_xls_new = basename($current_folder) . '_' . INFO_FILE . '.xlsx';

                    if (($file->getFilename() == $info_file_xls_old) || ($file->getFilename() == $info_file_xls_new)) {
                        $signatureFolder = basename($current_folder);

                        $inputProcessedFilesPath =
                            $current_folder . '/' . $signatureFolder . '_' . DONE_FILE;
                        $inputOmekaInfoPath =
                            $current_folder . '/' . $signatureFolder . '_' . OMEKA_INFO_FILE;

                        if (file_exists($inputProcessedFilesPath) && file_exists($inputOmekaInfoPath)) {

                            $str = file_get_contents($inputOmekaInfoPath);
                            $json = json_decode($str, false);
                            if (isset($json->collection->id)) {
                                $this->wsLogMessage("Folder: " . $signatureFolder);
                                $this->wsLogMessage("I have to delete collection with id: " . $json->collection->id . " (with title: " . $json->collection->title . ")");

                                if (!$this->dryMode) {
                                    try {
                                        $response = $omekaAPI->getHttpClient()->collections->delete($json->collection->id);
                                        // echo print_r($response, true);
                                        if ($response->getStatusCode() === 204) {
                                            $message = "Collection with id: " . $json->collection->id . ' deleted with success!';
                                            $this->wsLogMessage($message);
                                        } else {
                                            $this->wsLogMessage("Error with collection " .  $json->collection->id . ": " . $response->getReasonPhrase());
                                        }
                                    } catch (Exception $e) {
                                        $this->wsLogMessage("Error: " . $e->getMessage());
                                    }
                                }
                            }

                        }
                    }

                }

            }

            // Execution Time - End
            $executionTimeEnd = microtime(true);
            // $executionTimeTotal = round($executionTimeEnd, 3) - round($executionTimeStart, 3);

            $this->wsAddStatistic("End of deleting collections from folder " . $inputFolder, date("l jS F \@ g:i:s a", $executionTimeEnd));

        }
        $this->wsMessageDone();

    }

}
