<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 26/10/17
 * Time: 17:29
 */

class OperationsManagement {

    private $socketServer;
    private $clientID;
    private $mailSender;

    /**
     * OperationsManagement constructor.
     * @param $socketServer
     */
    public function __construct($socketServer)
    {
        $this->socketServer = $socketServer;

        // Server settings
        /*
         * SMTPDebug: Debug output level. Options:
         * 0 No output
         * 1 Commands
         * 2 Data and commands
         * 3 As 2 plus connection status
         * 4 Low-level data output
        */
        /*
        $this->mailSender = new PHPMailer\PHPMailer\PHPMailer(true);

        $this->mailSender->SMTPDebug = 0;
        $this->mailSender->isSMTP();                                      // Set mailer to use SMTP
        $this->mailSender->Host = 'smtp.gmail.com';                       // Specify main and backup SMTP servers
        $this->mailSender->SMTPAuth = true;                               // Enable SMTP authentication
        $this->mailSender->Username = 'mailer@mind-ware.it';              // SMTP username
        $this->mailSender->Password = 'e_sg622PO';                        // SMTP password
        $this->mailSender->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
        $this->mailSender->Port = 587;                                    // TCP port to connect to

        $this->mailSender->setFrom(
            'mailer@mind-ware.it',
            'Mind@ware Mailer');

        $this->mailSender->addAddress(
            'francesco.beninatto@mind-ware.it',
            'Mind@ware Francesco');


        // Content
        $this->mailSender->isHTML(true);
        */
    }

    /**
     * @return mixed
     */
    public function getSocketServer()
    {
        return $this->socketServer;
    }

    /**
     * @param mixed $socketServer
     */
    public function setSocketServer($socketServer)
    {
        $this->socketServer = $socketServer;
    }

    /**
     * @return mixed
     */
    public function getClientID()
    {
        return $this->clientID;
    }

    /**
     * @param mixed $clientID
     */
    public function setClientID($clientID)
    {
        $this->clientID = $clientID;
    }

    /**
     * @return PHPMailer\PHPMailer\PHPMailer
     */
    public function getMailSender(): PHPMailer\PHPMailer\PHPMailer
    {
        return $this->mailSender;
    }

    public function sendMail($mailSubject, $mailBody)
    {
        if ($this->mailSender !== null) {
            try {
                $this->mailSender->Subject = $mailSubject;
                $this->mailSender->Body = $mailBody;
                $this->mailSender->send();
            } catch (Exception $e) {
                echo "Message could not be sent.\n";
                echo 'Mailer Error: ' . $this->mailSender->ErrorInfo . "\n";
            }
        }
    }

    public function formatSecondsToReadableString($value)
    {
        $hours = floor($value/3600);
        $value %= 3600;
        $minutes = floor($value/60);
        $value %= 60;
        $seconds = $value;
        return $hours . " hours and " . $minutes . " minutes and " . $seconds . " seconds";
    }

    public function getTimeArrayFromSeconds($value)
    {
        $hours = floor($value/3600);
        $value %= 3600;
        $minutes = floor($value/60);
        $value %= 60;
        $seconds = $value;

        $result = array();
        $result['hours'] = $hours;
        $result['minutes'] = $minutes;
        $result['seconds'] = $seconds;
        return $result;
    }

    public function wsOnMessage($clientID, $message, $messageLength, $binary) {

        $this->setClientID($clientID);

        if (strpos($message, 'setParam') !== false) {
            $command = explode(':', $message);
            if ($command[2] === 'true') {
                $this->{$command[1]} = true;
            } else if ($command[2] === 'false') {
                $this->{$command[1]} = false;
            } else {
                $this->{$command[1]} = $command[2];
            }
        } else if (strpos($message, 'callProcedure') !== false) {
            $command = explode(':', $message);
            if (method_exists($this, $command[1])) {
                echo "Function " . $command[1] . " exists";
                $this->{$command[1]}();
            } else {
                echo "Function " . $command[1] . " not exists";
                $this->getSocketServer()->wsSend(
                    $this->getClientID(),
                    "Function " . $command[1]  . " not exists in a class '" . get_class($this) . "'"
                );
            }
        }

    }

    /**
     * ==================================================
     * wsLogMessage
     * ==================================================
     *
     * Method used to write a generic message to client.
     *
     * @param string $message
     *
     */
    public function wsLogMessage($message) {

        if ($this->socketServer === null) {
            echo(strip_tags($message) . "\n");
        } else {
            $this->socketServer->wsSend(
                $this->clientID,
                $message
            );
        }

    }

    /**
     * ==================================================
     * wsMessageDone
     * ==================================================
     *
     * Method used to write a message to client and notify done procedure.
     * If $message parameter is not blank TMB Player will show it in a Message Box-
     *
     * @param string $message
     *
     */
    public function wsMessageDone($message = '') {

        if ($this->socketServer === null) {
            echo((trim($message) !== '') ? strip_tags($message) : "Operation closed.");
        } else {
            $this->socketServer->wsSend(
                $this->clientID, "done" . (trim($message) === '' ? '' : ":" . $message)
            );
        }

    }

    /**
     * ==================================================
     * wsAddStatistic
     * ==================================================
     *
     * Method used to write a message to client with a description and a value.
     * This method create a statistic record on local store of TMB Player.
     *
     * @param string $label
     * @param string $value
     */
    public function wsAddStatistic($label, $value) {

        if ($this->socketServer !== null) {
            $this->socketServer->wsSend(
                $this->clientID,
                "addToStore:Stats:" . base64_encode($label) . ":" . base64_encode($value)
            );
        }

    }

    /**
     * ==================================================
     * wsUpdateStatistics
     * ==================================================
     *
     * Method used to write a message to client for updating statistics store.
     * This method create or update statistic record on local store of TMB Player
     * using $key+$label as primary key on local store
     *
     * @param string $key
     * @param string $label
     * @param integer $value
     */
    public function wsUpdateStatistics($key, $label, $value) {

        if ($this->socketServer !== null) {
            $this->socketServer->wsSend(
                $this->clientID,
                "updateStore:Stats:" . $key . ":" . base64_encode($label) . ":" . $value
            );
        }

    }

    /**
     * ==================================================
     * wsAddError
     * ==================================================
     *
     * Method used to write an error message to client.
     * This method create an error record on local store of TMB Player with passed
     * type and description.
     *
     * @param string $error_type
     * @param string $error_description
     */
    public function wsAddError($error_type, $error_description) {

        if ($this->socketServer !== null) {
            $this->socketServer->wsSend(
                $this->clientID,
                "addToStore:Errors:" . base64_encode($error_type) . ":" . base64_encode($error_description)
            );
        } else {
            echo("An error occurred (" . trim($error_type) . "): " . trim(strip_tags($error_description)) . "\n");
        }

    }

}
