<?php
/**
 * Created by PhpStorm.
 * User: fbeninat
 * Date: 26/10/17
 * Time: 17:29
 */

require_once ("OperationsManagement.php");
require_once (__DIR__ . '/../constants.php');
require_once (__DIR__ . '/../TMBProcessor.php');

use Ramsey\Uuid\Uuid;

class ScanAppOperations extends OperationsManagement {

    public $inputFolderPath = '';
    public $syncOmeka = false;
    public $archiveUnit = -1;


    private $canvasNumber = 0;

    private function canvasCount() {

        $this->canvasNumber = 0;
        $this->filesCounter($this->inputFolderPath, '{' . implode(",",SUPPORTED_IMG_FILE_TYPES) . '}');

    }

    private function createJsonMetadata($inputFolder, $imgConversionReturnObj, $dbRow) {

        // Building template JSON stdClass object
        $activeObjectJSON = new stdClass();
        $activeObjectJSON->metadata = new stdClass();

        $activeObjectJSON->metadata->originalFileName = $dbRow->filename_tif;
        $activeObjectJSON->{'manifest_id'} = Uuid::uuid4()->toString();
        $activeObjectJSON->metadata->{'filename'} = $dbRow->filename_jpg;

        $md5_string = md5_file($inputFolder . '/Fullsizes/' . $dbRow->filename_progression . ".jpg");
        $activeObjectJSON->metadata->{'fileMD5'} = $md5_string;

        $activeObjectJSON->{'width'} = $imgConversionReturnObj->width;
        $activeObjectJSON->{'height'} = $imgConversionReturnObj->height;

        if (trim($imgConversionReturnObj->exifData) !== '') {
            $activeObjectJSON->metadata->{'exifData'} = trim($imgConversionReturnObj->exifData);
        } else {
            $activeObjectJSON->metadata->{'exifData'} = '';
        }

        // Building output file path
        $outputMetadataPath = $inputFolder . "/Metadata/" . $dbRow->filename_progression . ".json";
        // Opening in write mode output file pointer
        $filePointer = fopen($outputMetadataPath, 'w');
        // Encode JSON into file
        fwrite($filePointer, json_encode($activeObjectJSON));
        fclose($filePointer);

    }

    private function create_InfoMetadataFile($inputFolder, $dbRow) {

        $outputMetadataPath = $inputFolder . "/" . basename($inputFolder) . '_' . INFO_FILE . '.xlsx';

        $objPHPExcel = new PHPExcel();
        $cacheMehod = PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        PHPExcel_Settings::setCacheStorageMethod($cacheMehod);
        PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);

        $objPHPExcel->getDefaultStyle()->getFont()->setName('Abadi MT Condensed Light');
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);

        $objPHPExcel->getProperties()->setCreator("Mind@ware Srl");
        $objPHPExcel->getProperties()->setLastModifiedBy("Mind@ware Srl");
        $objPHPExcel->getProperties()->setTitle("Office 2007 info metadata");
        $objPHPExcel->getProperties()->setSubject("Office 2007 info metadata");
        $objPHPExcel->getProperties()->setDescription("Office 2007 info metadata");

        $sheet = $objPHPExcel->getActiveSheet()->setTitle("Main");

        $list = array();
        $objList = new stdClass();

        // echo print_r($dbRow, true);

        $objList->maintenanceagency = $dbRow->label_metadata_maintenance_agency;
        $objList->recordid = $dbRow->metadata_record_id;
        $objList->series = $dbRow->metadata_series;
        $objList->level = $dbRow->label_metadata_level;
        $objList->signature = $dbRow->metadata_signature;
        $objList->code = $dbRow->metadata_code;
        $objList->title = $dbRow->metadata_title;
        $objList->description = $dbRow->metadata_description;
        $objList->type = $dbRow->label_metadata_type;
        $objList->physdesc = $dbRow->label_metadata_phys_desc;
        $objList->legatura = $dbRow->label_metadata_legatura;
        $objList->extent = $dbRow->metadata_extent;
        $objList->creator = $dbRow->metadata_creator;

        $objList->otherfindaid = $dbRow->metadata_other_find_id;

        $objList->date_sec_start = $dbRow->metadata_date_sec_start;
        $objList->date_sec_specify_start = $dbRow->metadata_date_sec_specify_start;
        $objList->date_year_start = $dbRow->metadata_date_year_start;
        $objList->date_month_start = $dbRow->metadata_date_month_start;
        $objList->date_day_start = $dbRow->metadata_date_sec_start;
        $objList->date_start_certainty = $dbRow->metadata_date_start_certainty;

        $objList->date_sec_end = $dbRow->metadata_date_sec_end;
        $objList->date_sec_specify_end = $dbRow->metadata_date_sec_specify_end;
        $objList->date_year_end = $dbRow->metadata_date_year_end;
        $objList->date_month_end = $dbRow->metadata_date_month_end;
        $objList->date_day_end = $dbRow->metadata_date_year_end;
        $objList->date_end_certainty = $dbRow->metadata_date_end_certainty;

        $objList->date_notes = $dbRow->metadata_date_notes;
        $objList->name = $dbRow->metadata_name;
        $objList->altformavail = $dbRow->metadata_alt_form_val;
        $objList->operator = $dbRow->metadata_operator;
        $objList->red_black_print = $dbRow->metadata_red_black_print;


        $list [] = $objList;
        $dbfields = [
            'maintenanceagency', 'recordid', 'series', 'level', 'signature', 'code', 'title', 'description', 'type',
            'physdesc', 'legatura', 'extent', 'creator', 'otherfindaid',
            'date_sec_start', 'date_sec_specify_start', 'date_year_start', 'date_month_start', 'date_day_start', 'date_start_certainty',
            'date_sec_end', 'date_sec_specify_end', 'date_year_end', 'date_month_end', 'date_day_end', 'date_end_certainty',
            'date_notes', 'name', 'altformavail', 'operator', 'red_black_print'
        ];
        $this->fillHeaderAndValues($sheet, $list/*$list*/, INFO_FIELDS_ARRAY/*$labels*/, $dbfields/*$dbfields*/);

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

        $objWriter->save($outputMetadataPath);

        $objPHPExcel->disconnectWorksheets();
        unset($objPHPExcel);

    }

    private function create_TcMetadataFile($inputFolder, $dbRow) {

        $outputMetadataPath = $inputFolder . "/" . basename($inputFolder) . '_' . TC_FILE . '.xlsx';

        $objPHPExcel = new PHPExcel();
        $cacheMehod = PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        PHPExcel_Settings::setCacheStorageMethod($cacheMehod);
        PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);

        $objPHPExcel->getDefaultStyle()->getFont()->setName('Abadi MT Condensed Light');
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);

        $objPHPExcel->getProperties()->setCreator("Mind@ware Srl");
        $objPHPExcel->getProperties()->setLastModifiedBy("Mind@ware Srl");
        $objPHPExcel->getProperties()->setTitle("Office 2007 tc metadata");
        $objPHPExcel->getProperties()->setSubject("Office 2007 tc metadata");
        $objPHPExcel->getProperties()->setDescription("Office 2007 tc metadata");

        $sheet = $objPHPExcel->getActiveSheet()->setTitle("Main");

        $list = array();
        $objList = new stdClass();

        // echo print_r($dbRow, true);

        $objList->id = $dbRow->filename_progression;
        $objList->notes =  !empty($dbRow->notes) ? $dbRow->notes : "";
        $objList->originalFileName = $dbRow->filename_tif;
        $objList->filename = $dbRow->filename_jpg;
        $objList->fileMD5 = !empty($dbRow->fileMD5) ? $dbRow->fileMD5 : "";

        $objList->cartulazione1 = $dbRow->cartulazione1;
        $objList->cartulazioneProgression1 = $dbRow->cartulazioneProgression1;
        $objList->cartulazioneProgressionSpec1 = $dbRow->cartulazioneProgressionSpec1;
        $objList->cartulazioneNotes1 = $dbRow->cartulazioneNotes1;

        $objList->cartulazione2 = $dbRow->cartulazione2;
        $objList->cartulazioneProgression2 = $dbRow->cartulazioneProgression2;
        $objList->cartulazioneProgressionSpec2 = $dbRow->cartulazioneProgressionSpec2;
        $objList->cartulazioneNotes2 = $dbRow->cartulazioneNotes2;

        $objList->cartulazione3 = $dbRow->cartulazione3;
        $objList->cartulazioneProgression3 = $dbRow->cartulazioneProgression3;
        $objList->cartulazioneProgressionSpec3 = $dbRow->cartulazioneProgressionSpec3;
        $objList->cartulazioneNotes3 = $dbRow->cartulazioneNotes3;

        /*
        $this->metadataItFullPageIllustration = !empty($data['it_fullPageIllustration']) ? $data['it_fullPageIllustration'] : null;
        $this->metadataItIllustration = !empty($data['it_illustration']) ? $data['it_illustration'] : null;
        $this->metadataItDecoratedInitials = !empty($data['it_decoratedInitials']) ? $data['it_decoratedInitials'] : null;
        $this->metadataItOrnaments = !empty($data['it_ornaments']) ? $data['it_ornaments'] : null;
        $this->metadataItFrames = !empty($data['it_frames']) ? $data['it_frames'] : null;
        $this->metadataItIllumination = !empty($data['it_illumination']) ? $data['it_illumination'] : null;
        */

        $list [] = $objList;
        $dbfields = [
            'id', 'notes', 'originalFileName', 'filename', 'fileMD5',
            'cartulazione1', 'cartulazioneProgression1', 'cartulazioneProgressionSpec1', 'cartulazioneNotes1',
            'cartulazione2', 'cartulazioneProgression2', 'cartulazioneProgressionSpec2', 'cartulazioneNotes2',
            'cartulazione3', 'cartulazioneProgression3', 'cartulazioneProgressionSpec3', 'cartulazioneNotes3'

        ];
        $this->fillHeaderAndValues($sheet, $list/*$list*/, TC_FIELDS_ARRAY/*$labels*/, $dbfields/*$dbfields*/);

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

        $objWriter->save($outputMetadataPath);

        $objPHPExcel->disconnectWorksheets();
        unset($objPHPExcel);

    }


    private function fillHeaderAndValues($sheet, $list, $labelArray, $fieldArray) {

        $debug = false;

        foreach($labelArray as $key => $label) {
            $sheet->setCellValue($this->getCoordinates($key,1), $label);
        }
        $sheet->getStyle($this->getCoordinates(min(array_keys($labelArray)),1) . ":" . $this->getCoordinates(max(array_keys($labelArray)),1))->getFont()->setBold(true);

        $num_rows = $sheet->getHighestRow();
        $sheet->insertNewRowBefore($num_rows + 1, 1);
        $sheet->getStyle($this->getCoordinates(min(array_keys($labelArray)),2) . ":" . $this->getCoordinates(max(array_keys($labelArray)),2))->getFont()->setBold(false);

        if ($list !== null) {
            $rowIterator = $sheet->getRowIterator(2);

            foreach ($list as $element) {
                $currentRow = $rowIterator->current();

                /*
                if ($debug) {
                    echo "Processing element with recordid " . $element->recordid . "\n";
                }*/

                $cellIterator = $currentRow->getCellIterator();
                $cellIterator->setIterateOnlyExistingCells(false);
                foreach ($fieldArray as $field) {

                    /** @var PHPExcel_Cell $currentCell */
                    $currentCell = $cellIterator->current();

                    if ($debug) {
                        echo "\tField: " . $field . "";
                        echo "\tValue: " . $element->$field . "";
                        echo "\tCoordinates: " . $currentCell->getCoordinate() . "\n";
                    }

                    if (isset($element->$field) && $element->$field != NULL && $element->$field != '') {
                        $currentCell->setValue($element->$field);
                    }

                    $cellIterator->next();
                }

                $rowIterator->next();
            }

            /*
            for($column = min(array_keys($labelArray)) ; $column <= max(array_keys($labelArray)) ; $column++) {
                $sheet->getColumnDimensionByColumn($column)->setAutoSize(true);
            }

            $sheet->calculateColumnWidths();
            */

        }

    }

    private function getCoordinates($columnIndex,$rowIndex) {
        return PHPExcel_Cell::stringFromColumnIndex($columnIndex) . $rowIndex;
    }

    public function convertAndUpload() {

        $dir = rtrim($this->inputFolderPath, '/');

        $this->canvasCount();

        if ($this->canvasNumber > 0) {

            $scanAppConfig = include(__DIR__ . '/../scanapp/config.php');

            //error_log(print_r($scanAppConfig, true));
            //error_log($scanAppConfig['scanapp-db']['username']);


            if (!file_exists($this->inputFolderPath . '/Fullsizes')) {
                mkdir($this->inputFolderPath . '/Fullsizes', 0777, true);
            }
            if (!file_exists($this->inputFolderPath . '/Metadata')) {
                mkdir($this->inputFolderPath . '/Metadata', 0777, true);
            }

            $tmbprocessor = new TMBProcessor($this->syncOmeka, false);

            // Get a connection with scan app db e search data relative to current archive unit
            try {

                $db = new PDO(
                    $scanAppConfig['scanapp-db']['dsn'],
                    $scanAppConfig['scanapp-db']['username'],
                    $scanAppConfig['scanapp-db']['password']
                );

                // I have to select collection data... (TO-DO)
                $query = $db->prepare(
                    "SELECT mau.*, co1.label AS label_metadata_maintenance_agency, co2.label AS label_metadata_level,
co3.label AS label_metadata_type, co4.label AS label_metadata_phys_desc, co5.label AS label_metadata_legatura 
FROM metadata_archive_unit mau 
LEFT OUTER JOIN combos co1 on (co1.value = mau.metadata_maintenance_agency)
LEFT OUTER JOIN combos co2 on (co2.value = mau.metadata_level)
LEFT OUTER JOIN combos co3 on (co3.value = mau.metadata_type)
LEFT OUTER JOIN combos co4 on (co4.value = mau.metadata_phys_desc)
LEFT OUTER JOIN combos co5 on (co5.value = mau.metadata_legatura)
WHERE id = ? AND
(co1.name = ? OR co1.name IS NULL) AND
(co2.name = ? OR co2.name IS NULL) AND
(co3.name = ? OR co3.name IS NULL) AND
(co4.name = ? OR co4.name IS NULL) AND
(co5.name = ? OR co5.name IS NULL)");

                $query->execute(array($this->archiveUnit, 'maintenanceagency', 'level', 'type', 'physdesc', 'legatura'));
                while ($row = $query->fetch(PDO::FETCH_OBJ)) {
                    // Create _Info file
                    $this->create_InfoMetadataFile($dir, $row);
                }

                // Create _Tc file
                // $this->create_TcMetadataFile($dir);
                $outputMetadataPath = $dir . "/" . basename($dir) . '_' . TC_FILE . '.xlsx';

                $objPHPExcel = new PHPExcel();
                $cacheMehod = PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
                PHPExcel_Settings::setCacheStorageMethod($cacheMehod);
                PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);

                $objPHPExcel->getDefaultStyle()->getFont()->setName('Abadi MT Condensed Light');
                $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);

                $objPHPExcel->getProperties()->setCreator("Mind@ware Srl");
                $objPHPExcel->getProperties()->setLastModifiedBy("Mind@ware Srl");
                $objPHPExcel->getProperties()->setTitle("Office 2007 tc metadata");
                $objPHPExcel->getProperties()->setSubject("Office 2007 tc metadata");
                $objPHPExcel->getProperties()->setDescription("Office 2007 tc metadata");

                $sheet = $objPHPExcel->getActiveSheet()->setTitle("Main");

                $list = array();
                //$this->fillHeaderAndValues($sheet, null, TC_FIELDS_ARRAY/*$labels*/, []/*$dbfields*/);

                $query = $db->prepare(
                    "SELECT mau.*, 
co1.label AS label_cartulazione1, co2.label AS label_cartulazione2, co3.label AS label_cartulazione3 
FROM metadata_archive_image mau 
LEFT OUTER JOIN combos co1 on (co1.value = mau.cartulazione1)
LEFT OUTER JOIN combos co2 on (co2.value = mau.cartulazione2)
LEFT OUTER JOIN combos co3 on (co3.value = mau.cartulazione3)
WHERE archive_unit = ? AND 
(co1.name = ? OR co1.name IS NULL) AND
(co2.name = ? OR co2.name IS NULL) AND
(co3.name = ? OR co3.name IS NULL)");
                $query->execute(array($this->archiveUnit, 'cartulazione', 'cartulazione', 'cartulazione'));
                $convertedImages = 0;
                while ($row = $query->fetch(PDO::FETCH_OBJ)) {

                    // echo $row->yourcolumnname;
                    // echo print_r($row, true);

                    if (($row->is_white*1 === 0) && ($row->is_mutilate*1 === 0)) {
                        $this->wsLogMessage('updateInfoWaitingWindow:' . 'Converting image ' . $row->filename_tif . "...");

                        $convertedImages++;
                        $imgConversionReturnObj = $tmbprocessor->imageProcessor(
                            $this,
                            $this->inputFolderPath . '/' . $row->filename_tif,
                            $this->inputFolderPath . '/Fullsizes/' . $row->filename_progression . '.jpg'
                        );
                        $this->wsLogMessage('updateInfoWaitingWindow:' . 'Saving metadata relative to image ' . $row->filename_tif . "...");
                        $this->createJsonMetadata($this->inputFolderPath, $imgConversionReturnObj, $row);
                        // echo print_r($imgConversionReturnObj, true);
                        //$this->create_TcMetadataFile($dir, $row);
                        $this->wsLogMessage('updateProgress:' . round($convertedImages/$this->canvasNumber, 2));
                    }
                    $objList = new stdClass();

                    $objList->id = $row->filename_progression;
                    $objList->notes =  !empty($row->notes) ? $row->notes : "";
                    $objList->originalFileName = $row->filename_tif;
                    $objList->filename = $row->filename_jpg;
                    $objList->fileMD5 = !empty($row->fileMD5) ? $row->fileMD5 : "";

                    $objList->cartulazione1 = $row->label_cartulazione1;
                    $objList->cartulazioneProgression1 = $row->cartulazioneProgression1;
                    $objList->cartulazioneProgressionSpec1 = $row->cartulazioneProgressionSpec1;
                    $objList->cartulazioneNotes1 = $row->cartulazioneNotes1;

                    $objList->cartulazione2 = $row->label_cartulazione2;
                    $objList->cartulazioneProgression2 = $row->cartulazioneProgression2;
                    $objList->cartulazioneProgressionSpec2 = $row->cartulazioneProgressionSpec2;
                    $objList->cartulazioneNotes2 = $row->cartulazioneNotes2;

                    $objList->cartulazione3 = $row->label_cartulazione3;
                    $objList->cartulazioneProgression3 = $row->cartulazioneProgression3;
                    $objList->cartulazioneProgressionSpec3 = $row->cartulazioneProgressionSpec3;
                    $objList->cartulazioneNotes3 = $row->cartulazioneNotes3;

                    $objList->it_fullPageIllustration = $row->it_fullPageIllustration;
                    $objList->it_illustration = $row->it_illustration;
                    $objList->it_decoratedInitials = $row->it_decoratedInitials;
                    $objList->it_ornaments = $row->it_ornaments;
                    $objList->it_frames = $row->it_frames;
                    $objList->it_illumination = $row->it_illumination;

                    $list [] = $objList;

                }

                $dbfields = [
                    'id', 'notes', 'originalFileName', 'filename', 'fileMD5',
                    'cartulazione1', 'cartulazioneProgression1', 'cartulazioneProgressionSpec1', 'cartulazioneNotes1',
                    'cartulazione2', 'cartulazioneProgression2', 'cartulazioneProgressionSpec2', 'cartulazioneNotes2',
                    'cartulazione3', 'cartulazioneProgression3', 'cartulazioneProgressionSpec3', 'cartulazioneNotes3',
                    'it_fullPageIllustration', 'it_illustration', 'it_decoratedInitials', 'it_ornaments', 'it_frames', 'it_illumination'

                ];
                $this->fillHeaderAndValues($sheet, $list/*$list*/, TC_FIELDS_ARRAY/*$labels*/, $dbfields/*$dbfields*/);
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

                $objWriter->save($outputMetadataPath);

                $objPHPExcel->disconnectWorksheets();
                unset($objPHPExcel);


                $this->wsMessageDone("All images have been converted with success!");

            } catch (PDOException  $e) {
                echo "Error: ". $e;
            }

        } else {
            $this->wsMessageDone("There are no images to convert!");
        }

    }

    private function filesCounter($dir, $fileExtension) {

        $dir = rtrim($this->inputFolderPath, '/');

        if(file_exists($dir)) {

            if (is_dir($dir)) {
                $files = glob($dir . '/*.' . $fileExtension, GLOB_BRACE);

                if (( $files !== false ) && (count($files) > 0)) {
                    $this->canvasNumber += count($files);
                }
            }

            foreach(scandir($dir) as $f) {

                if(!$f || $f[0] == '.') {
                    continue; // Ignore hidden files
                }

                if(is_dir($dir . '/' . $f)) {

                    $currentDir = $dir . '/' . $f;
                    $files = glob($currentDir . '/*.' . $fileExtension, GLOB_BRACE);
                    if (( $files !== false ) && (count($files) > 0)) {
                        $this->canvasNumber += count($files);
                    }

                }
            }
        }

    }

}
